<?php
require_once __DIR__ . '/../../core/init.php';
header('Content-Type: application/json'); // Luôn trả về kiểu JSON

// Chỉ chấp nhận phương thức POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Phương thức không hợp lệ.']);
    exit;
}

// Kiểm tra dữ liệu đầu vào
if (empty($_POST['order_date_original']) || empty($_POST['user_id']) || empty($_POST['new_order_date'])) {
    echo json_encode(['status' => 'error', 'message' => 'Dữ liệu không hợp lệ. Vui lòng điền đủ thông tin.']);
    exit;
}

$order_date_original = $_POST['order_date_original'];
$user_id = (int)$_POST['user_id'];
$new_order_date = $_POST['new_order_date'];
$new_order_datetime = $new_order_date . ' ' . date('H:i:s');

$conn->begin_transaction();

try {
    $consolidated_code = 'PHTH-' . date('Ymd-His');
    $sql_update = "UPDATE cms_orders 
                   SET created = ?, consolidated_code = ?
                   WHERE user_init = ?
                   AND DATE(created) = ? 
                   AND consolidated_code IS NULL";
    
    $stmt_update = $conn->prepare($sql_update);
    if ($stmt_update === false) {
        throw new Exception("Lỗi khi chuẩn bị câu lệnh: " . $conn->error);
    }
    
    $stmt_update->bind_param('ssis', $new_order_datetime, $consolidated_code, $user_id, $order_date_original);
    $stmt_update->execute();
    
    $affected_rows = $stmt_update->affected_rows;
    if ($affected_rows == 0) {
        throw new Exception("Không có đơn hàng nào được cập nhật. Có thể các đơn đã được xử lý trước đó.");
    }

    $conn->commit();

    // Trả về kết quả thành công
    echo json_encode([
        'status' => 'success',
        'message' => "Cập nhật thành công ngày bán cho {$affected_rows} đơn hàng.",
        'consolidated_code' => $consolidated_code
    ]);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    // Trả về lỗi
    echo json_encode([
        'status' => 'error',
        'message' => 'Đã xảy ra lỗi: ' . $e->getMessage()
    ]);
    exit;
}