<?php require_once __DIR__ . '/../../templates/header.php'; ?>

<style>
    .summary-card { background-color:#fff; border:none; border-radius:0.75rem; box-shadow:0 .15rem 1.75rem 0 rgba(58,59,69,.15)!important; transition:all .2s ease-in-out; }
    .summary-card:hover { transform: translateY(-5px); }
    .summary-card .card-body { padding: 1.5rem; display: flex; justify-content: space-between; align-items: center; }
    .summary-card .text-content .label { font-size:0.8rem; font-weight:700; text-transform:uppercase; margin-bottom:0.25rem; }
    .summary-card .text-content .value { font-size:1.75rem; font-weight:700; }
    .summary-card .icon-circle { width:50px; height:50px; border-radius:50%; display:flex; align-items:center; justify-content:center; color:white; font-size:1.5rem; }

    /* Điều chỉnh chiều cao cho canvas biểu đồ để chúng lớn hơn */
    .chart-container {
        position: relative;
        height: 400px; /* Chiều cao cố định cho biểu đồ */
        width: 100%;
    }
</style>

<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Tổng quan cửa hàng</h1>
    </div>
    <div class="row">
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card summary-card"><div class="card-body"><div class="text-content"><div class="label" style="color:#4e73df;">Doanh thu hôm nay</div><div class="value text-gray-800" id="today_sales_amount">0</div></div><div class="icon-circle" style="background-color:#4e73df;"><i class="fas fa-dollar-sign"></i></div></div></div>
        </div>
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card summary-card"><div class="card-body"><div class="text-content"><div class="label" style="color:#1cc88a;">Giao dịch hôm nay</div><div class="value text-gray-800" id="today_order_count">0</div></div><div class="icon-circle" style="background-color:#1cc88a;"><i class="fas fa-file-invoice"></i></div></div></div>
        </div>
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card summary-card"><div class="card-body"><div class="text-content"><div class="label" style="color:#36b9cc;">Tổng tồn kho</div><div class="value text-gray-800" id="warehouse_inventory">0</div></div><div class="icon-circle" style="background-color:#36b9cc;"><i class="fas fa-warehouse"></i></div></div></div>
        </div>
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card summary-card"><div class="card-body"><div class="text-content"><div class="label" style="color:#f6c23e;">Sắp hết hàng (&lt;10)</div><div class="value text-warning" id="warehouse_low_stock">0</div></div><div class="icon-circle" style="background-color:#f6c23e;"><i class="fas fa-exclamation-triangle"></i></div></div></div>
        </div>
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card summary-card"><div class="card-body"><div class="text-content"><div class="label" style="color:#e74a3b;">Sản phẩm hết hàng</div><div class="value text-danger" id="warehouse_out_of_stock">0</div></div><div class="icon-circle" style="background-color:#e74a3b;"><i class="fas fa-ban"></i></div></div></div>
        </div>
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card summary-card"><div class="card-body"><div class="text-content"><div class="label" style="color:#858796;">Tổng số sản phẩm</div><div class="value text-gray-800" id="product_info_total">0</div></div><div class="icon-circle" style="background-color:#858796;"><i class="fas fa-boxes"></i></div></div></div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-primary">Doanh số 7 ngày gần nhất</h6></div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="salesByDayChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3"><h6 class="m-0 font-weight-bold text-primary">Top 10 sản phẩm bán chạy</h6></div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="salesByProductChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>

<script>
$(document).ready(function() {
    const formatCurrency = (number) => new Intl.NumberFormat('vi-VN', { style: 'currency', currency: 'VND' }).format(number || 0);
    const formatNumber = (number) => new Intl.NumberFormat('vi-VN').format(number || 0);
    const chartColors = ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b', '#858796', '#f8f9fc', '#5a5c69', '#d1d3e2', '#4e73df'];

    $.ajax({
        url: '/quanlybanhang/ajax/dashboard_ajax.php',
        type: 'GET',
        dataType: 'json',
        data: { action: 'get_dashboard_data' },
        success: function(response) {
            if (response.status === 'success') {
                const data = response.data;
                
                $('#today_sales_amount').text(formatCurrency(data.today_sales_amount));
                $('#today_order_count').text(formatNumber(data.today_order_count));
                $('#warehouse_inventory').text(formatNumber(data.warehouse_inventory));
                $('#warehouse_out_of_stock').text(formatNumber(data.warehouse_out_of_stock));
                $('#warehouse_low_stock').text(formatNumber(data.warehouse_low_stock));
                $('#product_info_total').text(formatNumber(data.product_info_total));

                renderSalesByDayChart(data.charts.sales_by_day);
                renderSalesByProductChart(data.charts.sales_by_product);
            }
        },
        error: function() {
            alert('Không thể tải dữ liệu tổng quan. Vui lòng thử lại.');
        }
    });

    function renderSalesByDayChart(chartData) {
        if (!chartData || chartData.length === 0) return;
        const ctx = document.getElementById('salesByDayChart').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: chartData.map(d => d.sale_day),
                datasets: [{ 
                    label: 'Doanh số', 
                    data: chartData.map(d => d.daily_total), 
                    backgroundColor: chartColors[0],
                    borderColor: chartColors[0],
                    borderWidth: 1
                }]
            },
            options: { 
                responsive: true, 
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top',
                        labels: {
                            font: {
                                size: 14 // Kích thước font cho legend
                            }
                        }
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                let label = context.dataset.label || '';
                                if (label) {
                                    label += ': ';
                                }
                                if (context.parsed.y !== null) {
                                    label += formatCurrency(context.parsed.y);
                                }
                                return label;
                            }
                        },
                        titleFont: {
                            size: 14
                        },
                        bodyFont: {
                            size: 14
                        },
                        padding: 10
                    }
                },
                scales: { 
                    x: {
                        ticks: {
                            font: {
                                size: 12 // Kích thước font cho trục x
                            }
                        }
                    },
                    y: { 
                        ticks: { 
                            callback: function(value) { return formatCurrency(value); },
                            font: {
                                size: 12 // Kích thước font cho trục y
                            }
                        } 
                    } 
                } 
            }
        });
    }

    function renderSalesByProductChart(chartData) {
        if (!chartData || Object.keys(chartData).length === 0) return;
        const ctx = document.getElementById('salesByProductChart').getContext('2d');
        const labels = Object.values(chartData).map(d => d.name);
        const data = Object.values(chartData).map(d => d.total);
        new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: labels,
                datasets: [{ 
                    data: data, 
                    backgroundColor: chartColors,
                    borderColor: '#ffffff', // Màu viền giữa các phần
                    borderWidth: 2
                }]
            },
            options: { 
                responsive: true, 
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'right', // Đặt legend sang phải để có thêm không gian
                        labels: {
                            font: {
                                size: 12 // Kích thước font cho legend
                            }
                        }
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                let label = context.label || '';
                                if (label) {
                                    label += ': ';
                                }
                                if (context.parsed !== null) {
                                    label += formatNumber(context.parsed) + ' sản phẩm'; // Hiển thị số lượng sản phẩm
                                }
                                return label;
                            }
                        },
                        titleFont: {
                            size: 14
                        },
                        bodyFont: {
                            size: 14
                        },
                        padding: 10
                    }
                }
            }
        });
    }
});
</script>