<?php
require_once __DIR__ . '/../../templates/header.php';
?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />

<style>
    body {
        background-color: #f8f9fc;
    }
    .select2-container--bootstrap-5 .select2-selection {
        border-radius: 0.375rem !important;
        min-height: calc(1.5em + 0.75rem + 2px);
        padding: 0.375rem 0.75rem;
        display: flex;
        align-items: center;
    }
    #char-counter {
        font-size: 0.85rem;
        color: #6c757d;
    }
    .nav-tabs .nav-link {
        border: none;
        border-bottom: 2px solid transparent;
        color: #5a5c69;
    }
    .nav-tabs .nav-link.active, .nav-tabs .nav-item.show .nav-link {
        font-weight: 600;
        color: #4e73df;
        border-color: #4e73df;
        background-color: transparent;
    }
    .btn-check:checked+.btn-outline-primary {
        background-color: #4e73df;
        border-color: #4e73df;
        color: #fff;
    }
    .btn-send-campaign {
        padding: 0.75rem 1.5rem;
        font-size: 1rem;
        font-weight: 600;
        letter-spacing: .05rem;
        box-shadow: 0 .125rem .25rem rgba(0,0,0,.075);
        transition: all .2s ease-in-out;
    }
    .btn-send-campaign:hover {
        transform: translateY(-2px);
        box-shadow: 0 .5rem 1rem rgba(0,0,0,.15);
    }
    .form-section-title {
        color: #4e73df;
        font-weight: 700;
        border-bottom: 1px solid #e3e6f0;
        padding-bottom: 0.75rem;
    }
</style>

<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Tin nhắn Marketing</h1>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <ul class="nav nav-tabs card-header-tabs" id="messagingTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="composer-tab" data-bs-toggle="tab" data-bs-target="#composer-pane" type="button" role="tab" aria-controls="composer-pane" aria-selected="true">
                        <i class="fas fa-paper-plane me-2"></i>Soạn tin nhắn
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="history-tab" data-bs-toggle="tab" data-bs-target="#history-pane" type="button" role="tab" aria-controls="history-pane" aria-selected="false">
                        <i class="fas fa-history me-2"></i>Lịch sử gửi tin
                    </button>
                </li>
            </ul>
        </div>
        <div class="card-body">
            <div class="tab-content" id="messagingTabContent">
                <div class="tab-pane fade show active" id="composer-pane" role="tabpanel" aria-labelledby="composer-tab">
                    <form id="send-message-form">
                        <div class="row">
                            <div class="col-lg-7 border-end pe-lg-4">
                                <h5 class="mb-3 form-section-title"><i class="fas fa-edit me-2"></i>Soạn Nội Dung</h5>
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Tên chiến dịch</label>
                                    <input type="text" id="campaign_name" class="form-control" placeholder="Ví dụ: Khuyến mãi Lễ 2/9" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Chọn mẫu tin nhắn (tùy chọn)</label>
                                    <div class="input-group">
                                        <select id="template-search" class="form-control" data-placeholder="Tìm hoặc chọn mẫu tin..."></select>
                                        <button type="button" class="btn btn-outline-primary" id="btn-manage-templates" data-bs-toggle="modal" data-bs-target="#templatesModal" title="Quản lý mẫu tin nhắn">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Nội dung tin nhắn</label>
                                    <textarea id="message_content" rows="6" class="form-control" placeholder="Sử dụng {ten_khach_hang} để cá nhân hóa." required></textarea>
                                    <div id="char-counter" class="text-end mt-1">0/160 ký tự (1 tin)</div>
                                </div>
                            </div>

                            <div class="col-lg-5 ps-lg-4 mt-4 mt-lg-0">
                                <h5 class="mb-3 form-section-title"><i class="fas fa-users me-2"></i>Chọn Người Nhận</h5>
                                <div class="btn-group w-100 mb-3" role="group">
                                    <input type="radio" class="btn-check" name="recipient_type" id="type_group" value="group" checked>
                                    <label class="btn btn-outline-primary" for="type_group">Gửi theo nhóm</label>
                                    <input type="radio" class="btn-check" name="recipient_type" id="type_individual" value="individual">
                                    <label class="btn btn-outline-primary" for="type_individual">Gửi cá nhân</label>
                                </div>

                                <div id="recipient-group-container">
                                    <label class="form-label fw-bold">Chọn nhóm khách hàng</label>
                                    <select id="customer-group-select" class="form-control" data-placeholder="Chọn một nhóm..."></select>
                                    <div class="mt-2 text-muted small">Số lượng người nhận ước tính: <strong id="group-recipient-count" class="text-primary">0</strong></div>
                                </div>

                                <div id="recipient-individual-container" style="display: none;">
                                    <label class="form-label fw-bold">Tìm và thêm khách hàng</label>
                                    <select id="customer-search" class="form-control" data-placeholder="Nhập tên hoặc SĐT..." multiple></select>
                                </div>
                            </div>
                        </div>
                        <hr class="my-4">
                        <div class="text-end">
                            <button type="submit" id="btn-send" class="btn btn-success btn-lg btn-send-campaign">
                                <i class="fas fa-rocket me-2"></i>Bắt đầu gửi chiến dịch
                            </button>
                        </div>
                    </form>
                </div>

                <div class="tab-pane fade" id="history-pane" role="tabpanel" aria-labelledby="history-tab">
                     <h5 class="mb-3 text-primary fw-bold">Lịch sử các chiến dịch đã gửi</h5>
                     <div class="table-responsive">
                        <table class="table table-hover" id="history-table">
                            <thead class="table-light">
                                <tr>
                                    <th>Tên chiến dịch</th>
                                    <th>Nội dung</th>
                                    <th>Đối tượng nhận</th>
                                    <th class="text-center">Số người nhận</th>
                                    <th>Thời gian gửi</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                     </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="templatesModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Quản lý Mẫu tin nhắn</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-5 border-end">
                        <h6 class="text-primary">Thêm/Sửa Mẫu</h6>
                        <form id="template-form">
                            <input type="hidden" id="template_id" name="template_id">
                            <div class="mb-3">
                                <label class="form-label">Tiêu đề mẫu</label>
                                <input type="text" id="template_title" name="template_title" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Nội dung mẫu</label>
                                <textarea id="template_content" name="template_content" rows="5" class="form-control" required></textarea>
                            </div>
                            <div class="d-flex justify-content-end">
                                <button type="button" id="btn-new-template" class="btn btn-secondary me-2">Tạo mới</button>
                                <button type="submit" class="btn btn-primary">Lưu mẫu</button>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-7">
                        <h6 class="text-primary">Danh sách Mẫu</h6>
                        <div class="table-responsive" style="max-height: 300px;">
                            <table class="table table-sm table-hover">
                                <thead><tr><th>Tiêu đề</th><th class="text-center">Hành động</th></tr></thead>
                                <tbody id="templates-list"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="/quanlybanhang/assets/js/messaging_script.js?v=1.2"></script>