<?php
require_once __DIR__ . '/../../templates/header.php';
?>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Quản lý Đơn hàng</h1>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><i class="fas fa-filter mr-2"></i>Bộ lọc và Tìm kiếm</h6>
        </div>
        <div class="card-body">
            <form id="filter-form">
                <div class="row align-items-end">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Chế độ xem</label>
                        <select class="form-select form-control" id="filterView">
                            <option value="all" selected>Tất cả đơn hàng</option>
                            <option value="debt">Đơn hàng còn nợ</option>
                            <option value="deleted">Đơn hàng đã hủy</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Mã đơn hàng</label>
                        <input type="text" class="form-control" id="code" placeholder="Nhập mã đơn hàng...">
                    </div>
                    <div class="col-md-2 mb-3">
                        <label class="form-label">Từ ngày</label>
                        <input type="date" class="form-control" id="from_date">
                    </div>
                    <div class="col-md-2 mb-3">
                        <label class="form-label">Đến ngày</label>
                        <input type="date" class="form-control" id="to_date">
                    </div>
                    <div class="col-md-2 mb-3">
                        <button type="submit" class="btn btn-primary w-100"><i class="fas fa-search fa-sm"></i> Lọc</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Danh sách đơn hàng</h6>
            <a href="/quanlybanhang/modules/pos/pos.php" class="btn btn-success btn-sm">
                <i class="fas fa-plus fa-sm"></i> Tạo đơn hàng mới
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover" id="ordersTable" width="100%" cellspacing="0">
                    <thead class="table-light">
                        <tr>
                            <th>Mã ĐH</th>
                            <th>Ngày bán</th>
                            <th>Khách hàng</th>
                            <th>Thu ngân</th>
                            <th class="text-end">Tổng tiền</th>
                            <th class="text-end">Còn nợ</th>
                            <th class="text-center">Trạng thái</th>
                            <th class="text-center">Hành động</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>

<script>
$(document).ready(function() {
    function formatNumber(num) { return (parseFloat(num) || 0).toLocaleString('vi-VN'); }
    
    var table = $('#ordersTable').DataTable({
        "processing": true,
        "serverSide": true,
        "searching": false,
        "ajax": {
            "url": "/quanlybanhang/ajax/orders_ajax.php",
            "type": "POST",
            "data": function(d) {
                d.action = 'get_orders_list';
                d.view_mode = $('#filterView').val();
                d.code = $('#code').val();
                d.from = $('#from_date').val();
                d.to = $('#to_date').val();
            }
        },
        "columns": [
            { "data": "output_code", "render": (data, type, row) => `<a href="detail.php?id=${row.ID}" class="fw-bold text-decoration-none">${data}</a>` },
            { "data": "sell_date" },
            { "data": "customer_name" },
            { "data": "username" },
            { "data": "total_money", "className": "text-end", "render": data => formatNumber(data) },
            { "data": "lack", "className": "text-end text-danger", "render": data => formatNumber(data) },
            { 
                "data": "order_status", 
                "className": "text-center",
                "render": function(data, type, row) {
                    // SỬA LẠI: Dùng parseInt() để đảm bảo so sánh số chính xác
                    if (parseInt(data) == 1) {
                        return '<span class="badge bg-success">Hoàn thành</span>';
                    }
                    return '<span class="badge bg-danger">Đã hủy</span>';
                }
            },
            { 
                "data": null, 
                "orderable": false, 
                "className": "text-center",
                "render": function(data, type, row) {
                    let buttons = `
                        <a href="/quanlybanhang/modules/pos/pos.php?edit_order_id=${row.ID}" class="text-warning" title="Sửa đơn hàng"><i class="fas fa-edit"></i></a>
                        <a href="/quanlybanhang/modules/orders/print_invoice.php?order_id=${row.ID}" target="_blank" class="text-secondary ms-2" title="In phiếu"><i class="fas fa-print"></i></a>
                    `;
                    // SỬA LẠI: Dùng parseInt() để đảm bảo so sánh số chính xác
                    if (parseInt(row.order_status) == 1) {
                         buttons += `
                            <a href="/quanlybanhang/modules/returns/create.php?order_id=${row.ID}" class="text-info ms-2" title="Trả hàng"><i class="fas fa-undo"></i></a>
                            <a href="#" class="text-danger ms-2 btn-delete-order" data-id="${row.ID}" title="Hủy đơn hàng"><i class="fas fa-trash"></i></a>
                         `;
                    }
                    return buttons;
                }
            }
        ],
        "language": { "url": "/quanlybanhang/assets/libs/datatables/vietnamese.json" },
        "order": [[1, "desc"]],
        "dom": "t<'d-flex justify-content-between align-items-center'<'#summary-info.py-2 fw-bold'>p>",
        "drawCallback": function(settings) { /* Phần này giữ nguyên */ }
    });

    $('#filter-form').on('submit', function(e) {
        e.preventDefault();
        table.ajax.reload();
    });

    $('#ordersTable tbody').on('click', '.btn-delete-order', function(e) {
        e.preventDefault(); 
        var orderId = $(this).data('id');
        
        if (confirm('Bạn có chắc chắn muốn hủy đơn hàng này? Hành động này sẽ hoàn lại số lượng hàng vào tồn kho.')) {
            $.ajax({
                url: '/quanlybanhang/ajax/orders_ajax.php',
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'delete_order',
                    order_id: orderId
                },
                success: function(response) {
                    alert(response.message);
                    if (response.status === 'success') {
                        table.ajax.reload();
                    }
                },
                error: function() {
                    alert('Đã xảy ra lỗi kết nối. Vui lòng thử lại.');
                }
            });
        }
    });
});
</script>