<?php
require_once __DIR__ . '/../../core/init.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: list.php');
    exit();
}

$user_id = intval($_POST['user_id'] ?? 0);
$date = $_POST['date'] ?? '';
$store_id = intval($_POST['store_id'] ?? 1);

$redirect_params = 'user_id=' . $user_id . '&from_date=' . $date . '&to_date=' . $date;

if (empty($user_id) || empty($date)) {
    header('Location: list.php?error=' . urlencode('Vui lòng chọn nhân viên và ngày.'));
    exit();
}

$conn->begin_transaction();
try {
    // BƯỚC 1 & 2 & 3: TÌM CÁC ĐƠN HÀNG HỢP LỆ (Giữ nguyên)
    $already_processed_order_ids = [];
    $result_all_slips = $conn->query("SELECT detail_order_id FROM cms_output");
    while ($slip_row = $result_all_slips->fetch_assoc()) {
        $orders_in_slip = json_decode($slip_row['detail_order_id'], true);
        if (is_array($orders_in_slip)) {
            $ids = array_column($orders_in_slip, 'id');
            $already_processed_order_ids = array_merge($already_processed_order_ids, $ids);
        }
    }
    $already_processed_order_ids = array_unique(array_filter($already_processed_order_ids, 'is_numeric'));

    $sql_candidate_orders = "SELECT id FROM cms_orders WHERE user_init = ? AND DATE(sell_date) = ? AND deleted = 0 AND order_status > 0";
    $stmt_candidate = $conn->prepare($sql_candidate_orders);
    $stmt_candidate->bind_param("is", $user_id, $date);
    $stmt_candidate->execute();
    $candidate_result = $stmt_candidate->get_result();
    $candidate_order_ids = [];
    while ($row = $candidate_result->fetch_assoc()) {
        $candidate_order_ids[] = $row['id'];
    }
    $stmt_candidate->close();
    $eligible_order_ids = empty($already_processed_order_ids) ? $candidate_order_ids : array_diff($candidate_order_ids, $already_processed_order_ids);

    if (empty($eligible_order_ids)) {
        throw new Exception('Không có đơn hàng mới nào hợp lệ để tạo phiếu.');
    }

    // BƯỚC 4: LẤY THÔNG TIN CHI TIẾT VÀ TỔNG HỢP
    $ids_placeholder = implode(',', array_fill(0, count($eligible_order_ids), '?'));
    $sql_details = "SELECT id, output_code, total_quantity, total_money, detail_order FROM cms_orders WHERE id IN ($ids_placeholder)";
    
    $stmt_details = $conn->prepare($sql_details);
    $stmt_details->bind_param(str_repeat('i', count($eligible_order_ids)), ...$eligible_order_ids);
    $stmt_details->execute();
    $details_result = $stmt_details->get_result();

    $included_orders_data = [];
    $all_items_detailed = []; // Mảng để gom tất cả chi tiết sản phẩm
    $grand_total_amount = 0;
    $grand_total_quantity = 0;

    while ($order = $details_result->fetch_assoc()) {
        $grand_total_amount += (float)($order['total_money'] ?? 0);
        $grand_total_quantity += (float)($order['total_quantity'] ?? 0);
        $included_orders_data[] = ['id' => $order['id'], 'code' => $order['output_code']];
        
        // === THAY ĐỔI START: Gom chi tiết sản phẩm, không tổng hợp ===
        $items_in_order = json_decode($order['detail_order'], true);
        if (is_array($items_in_order)) {
            $all_items_detailed = array_merge($all_items_detailed, $items_in_order);
        }
        // === THAY ĐỔI END ===
    }
    $stmt_details->close();
    
    // BƯỚC 5: TẠO MÃ PHIẾU VÀ LƯU VÀO DATABASE
    $last_slip_result = $conn->query("SELECT ID FROM cms_output ORDER BY ID DESC LIMIT 1");
    $last_slip_id = $last_slip_result ? ($last_slip_result->fetch_row()[0] ?? 0) : 0;
    $output_code = 'PS' . str_pad($last_slip_id + 1, 6, '0', STR_PAD_LEFT);

    $sql_insert = "INSERT INTO cms_output (output_code, user_init, date_order, store_id, total_quantity, total_money, detail_order_id, detail_product_id, created) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())";
    $stmt_insert = $conn->prepare($sql_insert);
    
    $included_orders_json = json_encode($included_orders_data);
    // Lưu lại danh sách chi tiết sản phẩm đúng như định dạng bạn cung cấp
    $detail_product_json = json_encode($all_items_detailed);
    
    $stmt_insert->bind_param("sisiddss", $output_code, $user_id, $date, $store_id, $grand_total_quantity, $grand_total_amount, $included_orders_json, $detail_product_json);
    
    if (!$stmt_insert->execute()) {
        throw new Exception("Lỗi khi lưu phiếu: " . $stmt_insert->error);
    }
    
    $stmt_insert->close();
    
    $conn->commit();
    header('Location: list.php?user_id=' . $user_id . '&from_date=' . $date . '&to_date=' . $date .'&success=' . urlencode('Tạo phiếu soạn hàng ' . $output_code . ' thành công!'));

} catch (Exception $e) {
    $conn->rollback();
    header('Location: list.php?error=' . urlencode('Lỗi: ' . $e->getMessage()));
}
exit();
?>