<?php
require_once __DIR__ . '/../../templates/header.php';

$order_id = intval($_GET['order_id'] ?? 0);
if ($order_id <= 0) { die("Đơn hàng không hợp lệ."); }

$sql_order = "SELECT o.*, c.customer_name FROM cms_orders AS o LEFT JOIN cms_customers AS c ON o.customer_id = c.ID WHERE o.id = ?";
$stmt = $conn->prepare($sql_order);
if ($stmt === false) { die("Lỗi SQL (order): " . htmlspecialchars($conn->error)); }
$stmt->bind_param("i", $order_id);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();
$stmt->close();
if (!$order) { die("Không tìm thấy đơn hàng."); }

$order_items = json_decode($order['detail_order'], true);

if (is_array($order_items) && !empty($order_items)) {
    $product_ids = array_filter(array_column($order_items, 'id'));
    if (!empty($product_ids)) {
        $products_info = [];
        $ids_placeholder = implode(',', array_fill(0, count($product_ids), '?'));
        $types = str_repeat('i', count($product_ids));
        $sql_products = "SELECT id, prd_name, prd_code, prd_origin_price FROM cms_products WHERE id IN ($ids_placeholder)";
        $stmt_products = $conn->prepare($sql_products);
        $stmt_products->bind_param($types, ...$product_ids);
        $stmt_products->execute();
        $products_result = $stmt_products->get_result();
        while($row = $products_result->fetch_assoc()) { $products_info[$row['id']] = $row; }
        $stmt_products->close();
        foreach ($order_items as $key => $item) {
            $product_id = $item['id'] ?? 0;
            if (isset($products_info[$product_id])) {
                $order_items[$key]['name'] = $item['name'] ?? $products_info[$product_id]['prd_name'];
                $order_items[$key]['code'] = $item['code'] ?? $products_info[$product_id]['prd_code'];
                $order_items[$key]['origin_price'] = $item['origin_price'] ?? $products_info[$product_id]['prd_origin_price'];
            } else {
                $order_items[$key]['name'] = $item['name'] ?? '[Sản phẩm đã xóa]';
                $order_items[$key]['code'] = $item['code'] ?? 'N/A';
                $order_items[$key]['origin_price'] = $item['origin_price'] ?? 0;
            }
        }
    }
}
$stmt_returned = $conn->prepare("SELECT product_id, SUM(quantity) as total_returned FROM cms_canreturn WHERE order_id = ? GROUP BY product_id");
$stmt_returned->bind_param("i", $order_id); $stmt_returned->execute();
$returned_items = [];
$returned_result = $stmt_returned->get_result();
while ($row = $returned_result->fetch_assoc()) { $returned_items[$row['product_id']] = $row['total_returned']; }
$stmt_returned->close();
?>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800"><a href="/quanlybanhang/modules/orders/list.php" class="text-dark me-2" title="Quay lại"><i class="fas fa-arrow-left"></i></a>Nhập trả hàng từ đơn hàng » <?php echo htmlspecialchars($order['output_code']); ?></h1>
    <form id="return-form">
        <input type="hidden" name="order_id" value="<?php echo $order['ID']; ?>">
        <input type="hidden" name="customer_id" value="<?php echo $order['customer_ID']; ?>">
        <div class="card shadow">
            <div class="card-header"><h6 class="m-0 font-weight-bold text-primary">Khách hàng: <?php echo htmlspecialchars($order['customer_name'] ?? 'Khách lẻ'); ?> | Nợ trên đơn này: <span class="text-danger"><?php echo number_format($order['lack'] ?? 0); ?></span></h6></div>
            <div class="card-body"><div class="table-responsive"><table class="table table-bordered">
                <thead class="table-light"><tr><th>STT</th><th>Mã hàng</th><th>Tên sản phẩm</th><th class="text-center">SL Mua</th><th class="text-center">Đã trả</th><th style="width: 150px;" class="text-center">SL Trả lại</th><th class="text-end">Giá bán</th><th class="text-end">Thành tiền trả</th></tr></thead>
                <tbody id="return-items-body">
                    <?php if(is_array($order_items) && !empty($order_items)): $stt = 1; ?>
                        <?php foreach($order_items as $item): 
                            $product_id = $item['id'] ?? 0;
                            $returned_qty = $returned_items[$product_id] ?? 0;
                            $max_returnable = ($item['quantity'] ?? 0) - $returned_qty;
                        ?>
                        <tr data-product-id="<?php echo $product_id; ?>">
                            <td class="text-center"><?php echo $stt++; ?></td>
                            <td><?php echo htmlspecialchars($item['code'] ?? 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($item['name'] ?? 'Không xác định'); ?></td>
                            <td class="text-center"><?php echo $item['quantity']; ?></td>
                            <td class="text-center text-danger"><?php echo $returned_qty; ?></td>
                            <td><input type="number" class="form-control form-control-sm return-qty text-center" value="0" min="0" max="<?php echo $max_returnable; ?>" data-price="<?php echo $item['price']; ?>" <?php if ($max_returnable <= 0) echo 'disabled'; ?>>
                                <input type="hidden" class="item-data-price" value="<?php echo $item['price']; ?>">
                                <input type="hidden" class="item-data-origin-price" value="<?php echo $item['origin_price'] ?? 0; ?>">
                            </td>
                            <td class="text-end"><?php echo number_format($item['price']); ?></td>
                            <td class="text-end line-total fw-bold text-danger">0</td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="8" class="text-center">Không có sản phẩm trong đơn hàng.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table></div></div>
            <div class="card-footer row align-items-center"><div class="col-md-6"><label>Ghi chú (nội dung chi tiền):</label><input type="text" id="notes" name="notes" class="form-control" placeholder="Ví dụ: Hoàn tiền cho khách trả hàng..."></div><div class="col-md-6 text-end"><h4 class="text-danger mb-3">Tổng tiền trả lại: <span id="total-return-amount">0</span></h4><button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Lưu phiếu trả hàng</button></div></div>
        </div>
    </form>
</div>
<?php require_once __DIR__ . '/../../templates/footer.php'; ?>
<script>
$(document).ready(function() {
    function calculateTotals() {
        let totalReturn = 0;
        $('#return-items-body tr').each(function() {
            let qty = parseInt($(this).find('.return-qty').val()) || 0;
            let price = parseFloat($(this).find('.return-qty').data('price')) || 0;
            let lineTotal = qty * price;
            // Hiển thị số âm
            $(this).find('.line-total').text((lineTotal > 0 ? -lineTotal : 0).toLocaleString('vi-VN'));
            totalReturn += lineTotal;
        });
         // Hiển thị số âm
        $('#total-return-amount').text((totalReturn > 0 ? -totalReturn : 0).toLocaleString('vi-VN'));
    }
    $('#return-items-body').on('input', '.return-qty', calculateTotals);

    // THAY THẾ TOÀN BỘ PHẦN SUBMIT BẰNG ĐOẠN NÀY
    $('#return-form').on('submit', function(e) {
        e.preventDefault();
        
        let items_to_return = [];
        $('#return-items-body tr').each(function() {
            let qty = parseInt($(this).find('.return-qty').val()) || 0;
            if (qty > 0) {
                items_to_return.push({
                    id: $(this).data('product-id'),
                    quantity: qty,
                    price: $(this).find('.item-data-price').val(),
                    origin_price: $(this).find('.item-data-origin-price').val()
                });
            }
        });

        if (items_to_return.length === 0) {
            alert('Vui lòng nhập số lượng trả lại cho ít nhất một sản phẩm.');
            return;
        }

        const payload = {
            action: 'process_return',
            order_id: $('input[name="order_id"]').val(),
            customer_id: $('input[name="customer_ID"]').val(),
            notes: $('input[name="notes"]').val(),
            items: items_to_return
        };
		

        if(confirm('Bạn có chắc chắn muốn xử lý trả hàng cho các sản phẩm đã chọn?')) {
            const submitButton = $(this).find('button[type="submit"]');
            submitButton.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Đang xử lý...');

            // Sử dụng $.ajax để gửi dữ liệu dạng JSON
            $.ajax({
                url: '/quanlybanhang/ajax/returns_ajax.php', // Đường dẫn tới file xử lý
                type: 'POST',
                data: JSON.stringify(payload), // Chuyển toàn bộ dữ liệu thành chuỗi JSON
                contentType: 'application/json; charset=utf-8', // Báo cho server đây là dữ liệu JSON
                dataType: 'json', // Dữ liệu trả về mong muốn là JSON
                success: function(response) {
                    alert(response.message);
                    if(response.status === 'success') {
                        // Nếu thành công, chuyển hướng về danh sách đơn hàng
                        window.location.href = '/quanlybanhang/modules/orders/list.php';
                    } else {
                        // Nếu có lỗi, bật lại nút bấm
                        submitButton.prop('disabled', false).html('<i class="fas fa-save me-2"></i> Lưu phiếu trả hàng');
                    }
                },
                error: function(xhr) {
                    // Xử lý lỗi kết nối hoặc lỗi nghiêm trọng
                    alert('Lỗi kết nối hoặc có lỗi nghiêm trọng ở server.');
                    console.error(xhr.responseText); // In lỗi ra console để debug
                    submitButton.prop('disabled', false).html('<i class="fas fa-save me-2"></i> Lưu phiếu trả hàng');
                }
            });
        }
    });
});
</script>