<?php
// BƯỚC 1: KHỞI TẠO VÀ XỬ LÝ LOGIC (KHÔNG IN RA BẤT CỨ THỨ GÌ)
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Kết nối database ngay từ đầu để xử lý POST
require_once __DIR__ . '/../../config/database.php';

// XỬ LÝ TẠO LỊCH HẸN (POST REQUEST) - ĐÃ ĐƯỢC CHUYỂN LÊN ĐẦU
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'create') {
    $customer_name = $conn->real_escape_string($_POST['customer_name']);
    $customer_phone = $conn->real_escape_string($_POST['customer_phone']);
    $appointment_datetime = $conn->real_escape_string($_POST['appointment_datetime']);
    $notes = $conn->real_escape_string($_POST['notes']);

    $customer_phone_normalized = preg_replace('/^0/', '84', $customer_phone);
    $content = "SUA XE ABC: Thong bao, xe cua quy khach ($customer_name) da sua xong. Moi quy khach den nhan vao luc " . date('H:i d/m/Y', strtotime($appointment_datetime)) . ". Cam on!";

    $sql = "INSERT INTO service_appointments (customer_name, customer_phone, appointment_datetime, notes, message, status) VALUES (?, ?, ?, ?, ?, 'pending')";
    $stmt = $conn->prepare($sql);
    
    if (!$stmt) {
         // Xử lý lỗi một cách an toàn hơn
        error_log("Lỗi prepare SQL: " . $conn->error);
        $_SESSION['flash_message'] = ['type' => 'error', 'title' => 'Lỗi Hệ Thống', 'text' => 'Không thể chuẩn bị truy vấn. Vui lòng thử lại sau.'];
    } else {
        $stmt->bind_param("sssss", $customer_name, $customer_phone_normalized, $appointment_datetime, $notes, $content);
        if ($stmt->execute()) {
            $_SESSION['flash_message'] = ['type' => 'success', 'title' => 'Thành công!', 'text' => 'Lịch hẹn đã được tạo. Tin nhắn sẽ được gửi qua ứng dụng Android.'];
        } else {
            error_log("Lỗi execute SQL: " . $stmt->error);
            $_SESSION['flash_message'] = ['type' => 'error', 'title' => 'Thất bại!', 'text' => 'Không thể tạo lịch hẹn.'];
        }
    }

    // Chuyển hướng về trang index để tránh gửi lại form
    header('Location: index.php');
    exit();
}


// BƯỚC 2: BẮT ĐẦU HIỂN THỊ GIAO DIỆN
require_once __DIR__ . '/../../templates/header.php';

// HIỂN THỊ THÔNG BÁO (NẾU CÓ)
if (isset($_SESSION['flash_message'])) {
    $flash = $_SESSION['flash_message'];
    echo "<script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: '{$flash['type']}',
                title: '{$flash['title']}',
                text: '{$flash['text']}',
                timer: 2500,
                showConfirmButton: false
            });
        });
    </script>";
    unset($_SESSION['flash_message']);
}

// LẤY DỮ LIỆU ĐỂ HIỂN THỊ TRÊN BẢNG
$filter_date = $_GET['date'] ?? date('Y-m-d');
$filter_status = $_GET['status'] ?? '';

$sql = "SELECT * FROM service_appointments WHERE DATE(appointment_datetime) = ?";
if (!empty($filter_status)) {
    $sql .= " AND status = ?";
}
$sql .= " ORDER BY appointment_datetime DESC";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Lỗi prepare SQL: " . $conn->error);
}

if (!empty($filter_status)) {
    $stmt->bind_param("ss", $filter_date, $filter_status);
} else {
    $stmt->bind_param("s", $filter_date);
}

if (!$stmt->execute()) {
    die("Lỗi execute SQL: " . $stmt->error);
}
$appointments = $stmt->get_result();

$status_classes = [
    'pending' => 'warning', 'sent' => 'info',
    'completed' => 'success', 'cancelled' => 'danger',
];
?>

<style>
    body { background-color: #f8f9fc; }
    .card { border: none; border-radius: 0.75rem; box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.1); }
    .table-hover tbody tr:hover { background-color: #f1f3f5; cursor: pointer; }
    .badge { font-size: 0.8rem; padding: 0.5em 0.75em; }
</style>

<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Dịch vụ nhận sửa</h1>
    </div>

    <div class="row">
        <div class="col-lg-4 mb-4">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h6 class="m-0 font-weight-bold"><i class="fas fa-plus-circle me-2"></i>Tạo yêu cầu sửa chữa</h6>
                </div>
                <div class="card-body">
                    <form id="appointment-form" action="index.php" method="POST">
                        <input type="hidden" name="action" value="create">
                        <div class="mb-3">
                            <label for="customer_name" class="form-label">Họ tên khách hàng</label>
                            <input type="text" class="form-control" id="customer_name" name="customer_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="customer_phone" class="form-label">Số điện thoại</label>
                            <input type="tel" class="form-control" id="customer_phone" name="customer_phone" required pattern="^0[1-9][0-9]{8,9}$" placeholder="Nhập số điện thoại (10-11 số)">
                        </div>
                        <div class="mb-3">
                            <label for="appointment_datetime" class="form-label">Ngày giờ hẹn lấy xe</label>
                            <input type="datetime-local" class="form-control" id="appointment_datetime" name="appointment_datetime" required>
                        </div>
                        <div class="mb-3">
                            <label for="notes" class="form-label">Ghi chú (Tình trạng xe, đồ kèm theo...)</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                        </div>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Lưu và hẹn giờ</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-8">
            <div class="card">
                <div class="card-header bg-white">
                    <h6 class="m-0 font-weight-bold text-primary">Lịch sử nhận sửa</h6>
                    <form class="mt-3" method="GET">
                        <div class="row g-2">
                            <div class="col-md-5">
                                <input type="date" name="date" class="form-control" value="<?php echo htmlspecialchars($filter_date); ?>">
                            </div>
                            <div class="col-md-5">
                                <select name="status" class="form-select">
                                    <option value="">Tất cả trạng thái</option>
                                    <option value="pending" <?php if($filter_status == 'pending') echo 'selected'; ?>>Chờ gửi</option>
                                    <option value="sent" <?php if($filter_status == 'sent') echo 'selected'; ?>>Đã gửi</option>
                                    <option value="completed" <?php if($filter_status == 'completed') echo 'selected'; ?>>Hoàn thành</option>
                                    <option value="cancelled" <?php if($filter_status == 'cancelled') echo 'selected'; ?>>Đã hủy</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary w-100"><i class="fas fa-filter"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Khách hàng</th>
                                    <th>Giờ hẹn</th>
                                    <th>Trạng thái</th>
                                    <th>Hành động</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($appointments->num_rows > 0) : ?>
                                    <?php while ($row = $appointments->fetch_assoc()) : ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo htmlspecialchars($row['customer_name']); ?></strong>
                                                <br>
                                                <small class="text-muted"><?php echo htmlspecialchars($row['customer_phone']); ?></small>
                                            </td>
                                            <td><?php echo date('H:i', strtotime($row['appointment_datetime'])); ?></td>
                                            <td>
                                                <?php
                                                    $status_text = htmlspecialchars(ucfirst($row['status']));
                                                    $status_class = $status_classes[$row['status']] ?? 'secondary';
                                                ?>
                                                <span class="badge rounded-pill bg-<?php echo $status_class; ?>"><?php echo $status_text; ?></span>
                                            </td>
                                            <td>
                                                <a href="print.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-secondary" title="In phiếu hẹn" target="_blank"><i class="fas fa-print"></i></a>
                                                <a href="handler.php?action=delete&id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-danger btn-delete" title="Xóa"><i class="fas fa-trash-alt"></i></a>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                <?php else : ?>
                                    <tr>
                                        <td colspan="4" class="text-center p-5 text-muted">Không có lịch hẹn nào.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../templates/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="assets/main.js?v=<?php echo time(); ?>"></script>