<?php
// Thay thế bằng file header của bạn
require_once __DIR__ . '/../../templates/header.php';
?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />

<style>
    #zns-parameters-container .input-group { margin-bottom: 0.75rem; }
    #zns-preview-container { background-color: #f0f2f5; border: 1px solid #dee2e6; padding: 1.5rem; border-radius: 0.5rem; }
    #zns-preview-box { background-color: #fff; border: 1px solid #ccc; border-radius: 12px; padding: 12px; max-width: 350px; margin: auto; font-family: Arial, sans-serif; font-size: 14px; line-height: 1.4; }
    #zns-preview-header { font-weight: bold; margin-bottom: 8px; }
</style>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Gửi tin nhắn Zalo ZNS</h1>

    <div class="card shadow mb-4">
        <div class="card-body p-4">
            <form id="send-zns-form">
                <div class="row">
                    <div class="col-lg-7 border-end pe-lg-4">
                        <h5 class="mb-3 text-primary"><i class="fas fa-edit me-2"></i> Soạn Nội Dung ZNS</h5>
                        
                        <div class="mb-3">
                            <label for="campaign_name" class="form-label fw-bold">Tên chiến dịch</label>
                            <input type="text" id="campaign_name" class="form-control" placeholder="Ví dụ: Gửi ZNS xác nhận đơn hàng 11/09" required>
                        </div>

                        <div class="mb-3">
                            <label for="zns-template-select" class="form-label fw-bold">Chọn mẫu Zalo ZNS (*)</label>
                            <select id="zns-template-select" class="form-select" required></select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Điền tham số cho mẫu</label>
                            <div id="zns-parameters-container" class="p-3 border rounded bg-light">
                                <p class="text-muted text-center">Vui lòng chọn một mẫu để hiển thị tham số.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-5 ps-lg-4 mt-4 mt-lg-0">
                         <h5 class="mb-3 text-primary"><i class="fas fa-eye me-2"></i> Xem Trước</h5>
                         <div id="zns-preview-container">
                            <div id="zns-preview-box">
                                <div id="zns-preview-header">[Tên Zalo OA của bạn]</div>
                                <div id="zns-preview-content">Nội dung tin nhắn sẽ được hiển thị ở đây...</div>
                            </div>
                         </div>
                         <hr>
                         <h5 class="mb-3 text-primary"><i class="fas fa-users me-2"></i> Chọn Người Nhận</h5>
                         <p class="text-muted">Phần chọn người nhận sẽ được tích hợp ở đây.</p>
                    </div>
                </div>
                <hr class="my-4">
                <div class="text-end">
                    <button type="submit" id="btn-send" class="btn btn-success btn-lg">
                        <i class="fas fa-rocket me-2"></i>Bắt đầu gửi chiến dịch ZNS
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php 
// Thay thế bằng file footer của bạn
require_once __DIR__ . '/../../templates/footer.php'; 
?>

<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="assets/js/zns_script.js?v=1.0"></script>