<?php
/**
 * Tên file: process_login.php
 * Chức năng: Xử lý đăng nhập và điều hướng thông minh dựa trên thiết bị.
 */

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
session_start();

// Nạp các file cần thiết
require_once __DIR__ . '/core/init.php';
require_once __DIR__ . '/core/helpers.php'; // File chứa hàm is_mobile()

// Chỉ xử lý nếu phương thức là POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: login.php');
    exit();
}

$username = trim($_POST['username'] ?? '');
$password = trim($_POST['password'] ?? '');

if (empty($username) || empty($password)) {
    header('Location: login.php?error=1'); // Lỗi: thiếu thông tin
    exit();
}

// Truy vấn thông tin người dùng
$stmt = $conn->prepare("SELECT * FROM cms_users WHERE username = ? LIMIT 1");
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $user = $result->fetch_assoc();

    // Kiểm tra trạng thái hoạt động
    if ($user['user_status'] != 1) {
        header('Location: login.php?error=2'); // Lỗi: tài khoản bị khóa
        exit();
    }

    // Xác thực mật khẩu
    if (password_verify($password, $user['password'])) {
        // Lưu session
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['display_name'] = $user['display_name'];
        $_SESSION['group_id'] = $user['group_id'];
        $_SESSION['store_id'] = $user['store_id'];

        // Lấy quyền hạn
        $stmt_group = $conn->prepare("SELECT group_permission FROM cms_users_group WHERE id = ?");
        $stmt_group->bind_param("i", $user['group_id']);
        $stmt_group->execute();
        $group_result = $stmt_group->get_result()->fetch_assoc();
        $_SESSION['user_permissions'] = !empty($group_result['group_permission']) ? json_decode($group_result['group_permission'], true) : [];
        $stmt_group->close();
        
        // --- LOGIC ĐIỀU HƯỚNG MỚI ---
        // 1. Ưu tiên kiểm tra thiết bị trước
        if (is_mobile()) {
            // Nếu là điện thoại -> Vào thẳng giao diện bán hàng Mobile
            // Lưu ý: Đảm bảo đường dẫn này đúng với cấu trúc thư mục của bạn
            // Nếu file nằm trong modules/pos/ thì sửa thành: header('Location: modules/pos/pos-mobile.php');
            header('Location: modules/pos/pos-mobile.php'); 
        } else {
            // 2. Nếu là máy tính -> Vào trang quản trị (Dashboard)
            header('Location: modules/dashboard/');
        }
        exit();
        
    } else {
        header('Location: login.php?error=1'); // Sai mật khẩu
        exit();
    }
} else {
    header('Location: login.php?error=1'); // Sai tên đăng nhập
    exit();
}
?>