<?php
$print_settings = [];
// Giả định biến $conn đã được khởi tạo
$result = $conn->query("SELECT content FROM cms_templates WHERE id = 1");
if ($result && $result->num_rows > 0) {
    $settings_json = $result->fetch_assoc()['content'];
    $print_settings = json_decode($settings_json, true);
}
?>

<style>
    .page-header {
        border-bottom: 2px solid #000;
        padding-bottom: 15px;
        margin-bottom: 20px;
        font-size: 11pt;
        line-height: 1.6;
    }

    /* Bố cục chính cho logo và tiêu đề */
    .header-top-flex {
        display: flex;
        align-items: center; /* Đây là thuộc tính quan trọng nhất để căn giữa logo và chữ */
        width: 100%;
        gap: 20px; /* Tạo khoảng cách giữa logo và khối chữ */
    }

    /* Tùy chỉnh logo */
    .logo-container {
        flex-shrink: 0; /* Không cho logo bị co lại */
    }

    .logo-container img {
        max-height: 80px; /* Tăng chiều cao tối đa của logo */
        width: auto; /* Chiều rộng tự động để giữ tỷ lệ */
        display: block;
    }

    /* Tùy chỉnh khối thông tin công ty */
    .company-info-container {
        flex-grow: 1; /* Cho phép khối chữ chiếm không gian còn lại */
        text-align: center;
    }

    /* Tên công ty - Nổi bật, đặc biệt */
    .company-info-container .company-name {
        font-size: 32pt; /* Tăng kích thước chữ */
        font-weight: bold;
        color: #212529; /* Màu đen đậm sang trọng */
        text-transform: uppercase;
        margin: 0;
        padding: 0;
        line-height: 1.1;
    }

    /* Slogan/Ngành nghề kinh doanh - Đẹp và rõ ràng */
    .company-info-container .company-slogan {
        font-size: 14pt;
        color: #495057; /* Màu xám đậm, nhẹ nhàng hơn tên công ty */
        letter-spacing: 1px; /* Tăng khoảng cách ký tự cho dễ đọc */
        margin: 5px 0 0 0;
        padding: 0;
    }

    /* Khối địa chỉ, SĐT... bên dưới */
    .header-details-block {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        width: 100%;
        margin-top: 15px;
    }

    .detail-col {
        width: 48%;
    }
</style>

<header class="page-header">
    <div class="header-top-flex">
        <div class="logo-container">
            <?php if (!empty($print_settings['company_logo'])): ?>
                <?php 
                    $logo_url = stripslashes($print_settings['company_logo']);
                ?>
                <img src="/quanlybanhang/<?php echo htmlspecialchars($logo_url); ?>" alt="Company Logo">
            <?php endif; ?>
        </div>
        <div class="company-info-container">
            <div class="company-name"><?php echo htmlspecialchars($print_settings['company_name'] ?? 'TÊN CÔNG TY'); ?></div>
            <div class="company-slogan"><?php echo htmlspecialchars($print_settings['company_specialty_items'] ?? 'XE ĐẠP - XE ĐẠP ĐIỆN'); ?></div>
        </div>
    </div>

    <div class="header-details-block">
        <div class="detail-col">
            <div><strong>Địa chỉ:</strong> <?php echo htmlspecialchars($print_settings['company_address'] ?? 'Chưa có địa chỉ'); ?></div>
            <div><strong>SĐT:</strong> <?php echo htmlspecialchars($print_settings['company_phone'] ?? 'Chưa có SĐT'); ?></div>
            <?php if (!empty($print_settings['company_tax_code'])): ?>
                <div><strong>MST:</strong> <?php echo htmlspecialchars($print_settings['company_tax_code']); ?></div>
            <?php endif; ?>
        </div>

        <div class="detail-col">
             <?php if (!empty($print_settings['company_bank_info']) || !empty($print_settings['company_bank_accounts'])): ?>
                <div class="bank-info">
                    <div><strong>Chi nhánh NH:</strong> <?php echo htmlspecialchars($print_settings['company_bank_info'] ?? ''); ?></div>
                    <div><strong>Số TK:</strong><br>
                    <?php echo nl2br(htmlspecialchars($print_settings['company_bank_accounts'] ?? '')); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</header>