<?php
// --- BẮT ĐẦU PHẦN SỬA ĐỔI ---
// THAY VÌ GỌI init.php, chúng ta sẽ gọi trực tiếp các file cần thiết.
// Việc này đảm bảo không ảnh hưởng đến các chức năng khác đang chạy trên hosting.

// 1. Nạp file cấu hình database và các hàm dùng chung
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../core/functions.php';

// 2. Bắt đầu session để kiểm tra đăng nhập (nếu cần trong tương lai)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// --- KẾT THÚC PHẦN SỬA ĐỔI ---


// Các phần còn lại của file giữ nguyên không đổi
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['action'])) {
    die();
}

if ($_POST['action'] == 'get_orders_for_consolidation') {
    // Code xử lý logic không có gì thay đổi...
    $user_id = (int)$_POST['user_id'];
    $order_date = $_POST['order_date'];

    $sql = "SELECT 
                o.id, 
                c.customer_name, 
                o.total_quantity, 
                o.total_money 
            FROM cms_orders AS o
            LEFT JOIN cms_customers AS c ON o.customer_pay = c.id
            WHERE o.user_init = ? 
            AND DATE(o.created) = ? 
            AND o.consolidated_code IS NULL 
            ORDER BY o.id ASC";
            
    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        die("LỖI TRUY VẤN SQL: " . htmlspecialchars($conn->error));
    }
            
    $stmt->bind_param('is', $user_id, $order_date);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Toàn bộ phần code hiển thị HTML của bảng kết quả và form hành động
        // được giữ nguyên y hệt như các phiên bản trước.
        ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Danh sách đơn hàng tìm thấy (<?php echo $result->num_rows; ?> đơn)</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>STT</th>
                                <th>Mã đơn hàng</th>
                                <th>Tên khách hàng</th>
                                <th>Tổng SL</th>
                                <th>Tổng tiền</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $stt = 1; while ($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $stt++; ?></td>
                                <td><?php echo 'BH' . str_pad($row['id'], 6, '0', STR_PAD_LEFT); ?></td>
                                <td><?php echo htmlspecialchars($row['customer_name'] ?? 'Khách lẻ'); ?></td>
                                <td><?php echo $row['total_quantity']; ?></td>
                                <td class="text-right"><?php echo number_format($row['total_money']); ?></td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div id="action-form-container">
            <form id="action-form">
                <input type="hidden" name="user_id" id="form_user_id" value="<?php echo $user_id; ?>">
                <input type="hidden" name="order_date_original" id="form_order_date_original" value="<?php echo $order_date; ?>">
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Hành động</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="new_order_date">Nhập ngày mới cần cập nhật:</label>
                            <input type="date" id="new_order_date" name="new_order_date" class="form-control" value="<?php echo date('Y-m-d', strtotime('+1 day', strtotime($order_date))); ?>" required>
                        </div>
                        <button type="button" id="confirm-update-btn" class="btn btn-success"><i class="fas fa-check-circle mr-1"></i> Xác nhận Cập nhật</button>
                    </div>
                </div>
            </form>
        </div>
        <?php
    } else {
        echo '<div class="alert alert-warning">Không tìm thấy đơn hàng nào của nhân viên đã chọn trong ngày này hoặc các đơn đã được gộp trước đó.</div>';
    }
    $stmt->close();
}