<?php
// File: /pages/consolidate_orders/index.php
// Phần PHP và HTML của file này giữ nguyên như các lần trước
require_once __DIR__ . '/../../templates/header.php';
$users_result = $conn->query("SELECT id, username, display_name FROM cms_users WHERE user_status = 1 ORDER BY username ASC");
?>
<style>
    /* Thêm vào file giao diện của bạn */
    .processed-row {
        background-color: #f2f2f2 !important; /* Màu nền xám */
        color: #999; /* Chữ màu xám */
        text-decoration: line-through; /* Gạch ngang chữ */
        opacity: 0.7; /* Hơi trong suốt */
    }
    .processed-row td:last-child {
        font-weight: normal;
    }
</style>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Gộp và Cập nhật Ngày Đơn Hàng</h1>
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Bước 1: Lọc và xem trước đơn hàng</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-5">
                    <div class="form-group">
                        <label for="user_id">Chọn nhân viên bán hàng:</label>
                        <select id="user_id" name="user_id" class="form-control">
                            <option value="">-- Chọn nhân viên --</option>
                            <?php while ($user = $users_result->fetch_assoc()) : ?>
                                <option value="<?php echo $user['id']; ?>">
                                    <?php echo htmlspecialchars($user['display_name'] ? $user['display_name'] . ' (' . $user['username'] . ')' : $user['username']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="form-group">
                        <label for="order_date_original">Chọn ngày bán hàng (để tìm đơn):</label>
                        <input type="date" id="order_date_original" class="form-control" value="<?php echo date('Y-m-d'); ?>">
                    </div>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <div class="form-group w-100">
                         <button type="button" id="viewOrdersBtn" class="btn btn-info btn-block"><i class="fas fa-eye mr-1"></i> Xem đơn hàng</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="results-container"></div>
</div>

<?php include __DIR__ . '/../../templates/footer.php'; ?>

<script>
$(document).ready(function() {
    // Sự kiện cho nút "Xem đơn hàng" - Giữ nguyên
    $('#viewOrdersBtn').on('click', function() {
        var userId = $('#user_id').val();
        var originalDate = $('#order_date_original').val();
        if (!userId || !originalDate) {
            alert('Vui lòng chọn nhân viên và ngày bán hàng.');
            return;
        }
        $('#results-container').html('<div class="text-center mt-4"><div class="spinner-border text-primary" role="status"></div><p class="mt-2">Đang tải...</p></div>');
        $.ajax({
            url: 'ajax_handler.php',
            type: 'POST',
            data: {
                action: 'get_orders_for_consolidation',
                user_id: userId,
                order_date_original: originalDate
            },
            success: function(response) {
                $('#results-container').html(response);
            },
            error: function() {
                $('#results-container').html('<div class="alert alert-danger mt-4">Đã có lỗi xảy ra khi tải dữ liệu.</div>');
            }
        });
    });

    // ***** BẮT ĐẦU THAY ĐỔI: Sửa sự kiện cho nút "Cập nhật" *****
    $(document).on('click', '#processBtn', function() {
        var button = $(this); // Lấy đối tượng nút bấm đã được click
        
        // Lấy dữ liệu từ data- attributes của nút bấm
        var userId = button.data('user-id');
        var originalDate = button.data('original-date');
        
        // Lấy ngày mới từ ô input
        var newDate = $('#new_delivery_date').val();

        if (!newDate) {
            alert('Vui lòng chọn ngày giao hàng mới.');
            return;
        }

        if (!confirm('Bạn có chắc chắn muốn cập nhật ngày cho tất cả các đơn hàng đã liệt kê không?')) {
            return;
        }
        
        button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Đang xử lý...');

        $.ajax({
            url: 'ajax_handler.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'update_and_consolidate',
                user_id: userId, // Dùng biến đã lấy từ data-attribute
                order_date_original: originalDate, // Dùng biến đã lấy từ data-attribute
                new_order_date: newDate
            },
            success: function(response) {
                if (response.status === 'success') {
                    var printUrl = 'print_consolidated.php?code=' + response.consolidated_code;
                    var successMessage = `
                        <div class="alert alert-success mt-4">
                            <h4><i class="fas fa-check-circle"></i> Thành công!</h4>
                            <p>${response.message}</p>
                            <p>Mã phiếu tổng hợp: <strong>${response.consolidated_code}</strong></p>
                            <a href="${printUrl}" target="_blank" class="btn btn-primary"><i class="fas fa-print mr-1"></i> Mở trang in phiếu</a>
                        </div>
                    `;
                    $('#results-container').html(successMessage);
                } else {
                    alert('Lỗi: ' + response.message);
                    button.prop('disabled', false).html('<i class="fas fa-check-circle mr-1"></i> Cập nhật ngày và In phiếu tổng hợp');
                }
            },
            error: function() {
                alert('Đã có lỗi không xác định xảy ra. Vui lòng thử lại.');
                button.prop('disabled', false).html('<i class="fas fa-check-circle mr-1"></i> Cập nhật ngày và In phiếu tổng hợp');
            }
        });
    });
    // ***** KẾT THÚC THAY ĐỔI *****
});
</script>