<?php
session_start();
require '../includes/db_connect.php';

// ==============================================================================
// =============== HÀM MỚI ĐỂ XÓA DẤU TIẾNG VIỆT ================================
// ==============================================================================
function remove_vietnamese_diacritics($str) {
    $str = preg_replace("/(à|á|ạ|ả|ã|â|ầ|ấ|ậ|ẩ|ẫ|ă|ằ|ắ|ặ|ẳ|ẵ)/", "a", $str);
    $str = preg_replace("/(è|é|ẹ|ẻ|ẽ|ê|ề|ế|ệ|ể|ễ)/", "e", $str);
    $str = preg_replace("/(ì|í|ị|ỉ|ĩ)/", "i", $str);
    $str = preg_replace("/(ò|ó|ọ|ỏ|õ|ô|ồ|ố|ộ|ổ|ỗ|ơ|ờ|ớ|ợ|ở|ỡ)/", "o", $str);
    $str = preg_replace("/(ù|ú|ụ|ủ|ũ|ư|ừ|ứ|ự|ử|ữ)/", "u", $str);
    $str = preg_replace("/(ỳ|ý|ỵ|ỷ|ỹ)/", "y", $str);
    $str = preg_replace("/(đ)/", "d", $str);
    $str = preg_replace("/(À|Á|Ạ|Ả|Ã|Â|Ầ|Ấ|Ậ|Ẩ|Ẫ|Ă|Ằ|Ắ|Ặ|Ẳ|Ẵ)/", "A", $str);
    $str = preg_replace("/(È|É|Ẹ|Ẻ|Ẽ|Ê|Ề|Ế|Ệ|Ể|Ễ)/", "E", $str);
    $str = preg_replace("/(Ì|Í|Ị|Ỉ|Ĩ)/", "I", $str);
    $str = preg_replace("/(Ò|Ó|Ọ|Ỏ|Õ|Ô|Ồ|Ố|Ộ|Ổ|Ỗ|Ơ|Ờ|Ớ|Ợ|Ở|Ỡ)/", "O", $str);
    $str = preg_replace("/(Ù|Ú|Ụ|Ủ|Ũ|Ư|Ừ|Ứ|Ự|Ử|Ữ)/", "U", $str);
    $str = preg_replace("/(Ỳ|Ý|Ỵ|Ỷ|Ỹ)/", "Y", $str);
    $str = preg_replace("/(Đ)/", "D", $str);
    return $str;
}
// ==============================================================================

if (!isset($_SESSION['user_id'])) { http_response_code(403); exit("Bạn cần đăng nhập."); }

// Lấy dữ liệu từ form
$customerName = trim($_POST['customerName'] ?? '');
$customerPhone = trim($_POST['customerPhone'] ?? '');
$vehicleType = $_POST['vehicleType'] ?? '';
$vehicleName = trim($_POST['vehicleName'] ?? '');
$repairDescription = trim($_POST['repairDescription'] ?? '');
$pickupTime = $_POST['pickupTime'] ?? '';
$sendSms = isset($_POST['sendSms']);
$userId = $_SESSION['user_id'];

// Lưu thông tin sửa chữa
$stmt = $conn->prepare("INSERT INTO repairs (customer_name, customer_phone, vehicle_type, vehicle_name, repair_description, pickup_time, status) VALUES (?, ?, ?, ?, ?, ?, 'đang sửa chữa')");
$stmt->bind_param("ssssss", $customerName, $customerPhone, $vehicleType, $vehicleName, $repairDescription, $pickupTime);
$stmt->execute();
$newRepairId = $conn->insert_id;
$stmt->close();

if ($sendSms && $newRepairId > 0) {
    $pickupTimeFormatted = date_format(date_create($pickupTime), 'H:i d/m/Y');
    
    // === TIN NHẮN 1: XÁC NHẬN NHẬN XE (Gửi ngay) ===
    $receiptMessage_raw = "XE ĐẠP CHÍ BẰNG THÔNG BÁO! da nhan sua chua {$vehicleType}, ten xe {$vehicleName} cua Anh/chi {$customerName}, thoi gian hen lay la {$pickupTimeFormatted}.";
    $receiptMessage_final = remove_vietnamese_diacritics($receiptMessage_raw); // Áp dụng hàm bỏ dấu
    
    $now = new DateTime("now", new DateTimeZone('Asia/Ho_Chi_Minh'));
    $scheduleTimeNow = $now->format('Y-m-d H:i:s');

    $smsStmt1 = $conn->prepare("INSERT INTO messages (user_id, phone_number, message, schedule_time, status) VALUES (?, ?, ?, ?, 'pending')");
    $smsStmt1->bind_param("isss", $userId, $customerPhone, $receiptMessage_final, $scheduleTimeNow);
    if ($smsStmt1->execute()) {
        $conn->query("UPDATE repairs SET sms_receipt_status = 'đã gửi' WHERE id = $newRepairId");
    }
    $smsStmt1->close();

    // === TIN NHẮN 2: HẸN LẤY XE (Gửi theo lịch hẹn) ===
    $pickupMessage_raw = "XE ĐẠP CHÍ BẰNG THÔNG BÁO! Xe {$vehicleName} cua Anh/chi {$customerName} da den gio hen lay. Kinh moi quy khach den nhan xe.";
    $pickupMessage_final = remove_vietnamese_diacritics($pickupMessage_raw); // Áp dụng hàm bỏ dấu

    $smsStmt2 = $conn->prepare("INSERT INTO messages (user_id, phone_number, message, schedule_time, status) VALUES (?, ?, ?, ?, 'pending')");
    $smsStmt2->bind_param("isss", $userId, $customerPhone, $pickupMessage_final, $pickupTime);
    if ($smsStmt2->execute()) {
        $conn->query("UPDATE repairs SET sms_pickup_status = 'đã gửi' WHERE id = $newRepairId");
    }
    $smsStmt2->close();
}

$conn->close();
header("Location: ../dashboard.php?success=added");
exit();
?>