<?php
session_start();
require '../includes/db_connect.php';

if (!isset($_SESSION['user_id'])) { exit("Bạn cần đăng nhập."); }

$userId = $_SESSION['user_id'];
$currentPassword = $_POST['current_password'];
$newPassword = $_POST['new_password'];
$confirmPassword = $_POST['confirm_password'];

// Kiểm tra mật khẩu mới có khớp không
if ($newPassword !== $confirmPassword) {
    header("Location: ../settings.php?error=passwordmismatch");
    exit();
}

// Lấy mật khẩu đã hash từ database
$stmt = $conn->prepare("SELECT password_hash FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

// Xác thực mật khẩu hiện tại
if ($user && password_verify($currentPassword, $user['password_hash'])) {
    // Hash mật khẩu mới
    $newPasswordHash = password_hash($newPassword, PASSWORD_DEFAULT);

    // Cập nhật mật khẩu mới vào database
    $updateStmt = $conn->prepare("UPDATE users SET password_hash = ? WHERE id = ?");
    $updateStmt->bind_param("si", $newPasswordHash, $userId);
    if ($updateStmt->execute()) {
        header("Location: ../settings.php?success=passwordchanged");
    } else {
        header("Location: ../settings.php?error=dberror");
    }
    $updateStmt->close();
} else {
    // Sai mật khẩu hiện tại
    header("Location: ../settings.php?error=currentpasswordwrong");
}

$conn->close();
exit();
?>