<?php
session_start();
require '../includes/db_connect.php';

if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    exit("Bạn cần đăng nhập.");
}

// Lấy dữ liệu từ form POST
$repairId = $_POST['repair_id'] ?? 0;
$repairDetails = $_POST['repair_details'] ?? '';
$mechanicName = $_POST['mechanic_name'] ?? '';
$repairCost = $_POST['repair_cost'] ?? 0;

if (empty($repairId) || empty($repairDetails) || empty($mechanicName)) {
    header("Location: ../dashboard.php?error=missingdata");
    exit();
}

// Câu lệnh UPDATE để cập nhật thông tin và trạng thái
$stmt = $conn->prepare(
    "UPDATE repairs SET repair_details = ?, mechanic_name = ?, repair_cost = ?, status = 'đã sửa chữa' WHERE id = ?"
);
$stmt->bind_param("ssdi", $repairDetails, $mechanicName, $repairCost, $repairId);

if ($stmt->execute()) {
    header("Location: ../dashboard.php?success=completed");
} else {
    header("Location: ../dashboard.php?error=dberror");
}

$stmt->close();
$conn->close();
exit();
?>