<?php
session_start();
require '../includes/db_connect.php';

// Bảo vệ: Chỉ người dùng đã đăng nhập mới được thực hiện
if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    exit("Bạn cần đăng nhập.");
}

// Lấy ID tin nhắn từ URL và user ID từ session
$messageId = $_GET['id'] ?? 0;
$userId = $_SESSION['user_id'];

// Kiểm tra xem ID có hợp lệ không
if (empty($messageId)) {
    header("Location: ../history.php?error=invalidid");
    exit();
}

// Câu lệnh DELETE an toàn:
// Chỉ xóa tin nhắn có ID khớp VÀ user_id cũng phải khớp
// Điều này ngăn người dùng A xóa tin nhắn của người dùng B
$stmt = $conn->prepare("DELETE FROM messages WHERE id = ? AND user_id = ?");
$stmt->bind_param("ii", $messageId, $userId);

if ($stmt->execute()) {
    // Nếu xóa thành công, chuyển hướng về trang lịch sử
    header("Location: ../history.php?success=deleted");
} else {
    // Nếu có lỗi, cũng chuyển hướng về trang lịch sử kèm thông báo lỗi
    header("Location: ../history.php?error=dberror");
}

$stmt->close();
$conn->close();
exit();
?>