<?php
session_start();
require '../includes/db_connect.php';

// Bảo vệ: Chỉ người dùng đã đăng nhập mới được thực hiện
if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    exit("Bạn cần đăng nhập.");
}

// Lấy ID từ URL
$repairId = $_GET['id'] ?? 0;

// Kiểm tra xem ID có hợp lệ không
if (empty($repairId)) {
    header("Location: ../dashboard.php?error=invalidid");
    exit();
}

// Câu lệnh DELETE an toàn
$stmt = $conn->prepare("DELETE FROM repairs WHERE id = ?");
$stmt->bind_param("i", $repairId);

if ($stmt->execute()) {
    // Nếu xóa thành công, chuyển hướng về trang chính
    header("Location: ../dashboard.php?success=deleted");
} else {
    // Nếu có lỗi, cũng chuyển hướng về trang chính kèm thông báo lỗi
    header("Location: ../dashboard.php?error=dberror");
}

$stmt->close();
$conn->close();
exit();
?>