<?php
session_start();
require '../includes/db_connect.php';

if (!isset($_SESSION['user_id'])) { exit("Bạn cần đăng nhập."); }

$userIdToDelete = $_GET['id'] ?? 0;

// BIỆN PHÁP AN TOÀN: Không cho phép người dùng tự xóa tài khoản của chính mình
if ($userIdToDelete == $_SESSION['user_id']) {
    header("Location: ../settings.php?error=selfdelete");
    exit();
}
if (empty($userIdToDelete)) { header("Location: ../settings.php?error=invalidid"); exit(); }

// Xóa người dùng và tất cả dữ liệu liên quan (tin nhắn, thiết bị, lịch sửa chữa)
$conn->begin_transaction();
try {
    $conn->prepare("DELETE FROM messages WHERE user_id = ?")->bind_param("i", $userIdToDelete)->execute();
    $conn->prepare("DELETE FROM devices WHERE user_id = ?")->bind_param("i", $userIdToDelete)->execute();
    $conn->prepare("DELETE FROM repairs WHERE user_id = ?")->bind_param("i", $userIdToDelete)->execute();
    $conn->prepare("DELETE FROM users WHERE id = ?")->bind_param("i", $userIdToDelete)->execute();
    $conn->commit();
    header("Location: ../settings.php?success=userdeleted");
} catch (Exception $e) {
    $conn->rollback();
    header("Location: ../settings.php?error=dberror");
}
$conn->close();
exit();
?>