<?php
session_start();
require '../includes/db_connect.php';

// Bảo vệ: Chỉ người dùng đã đăng nhập mới được thực hiện
if (!isset($_SESSION['user_id'])) {
    // Nếu chưa đăng nhập, chuyển hướng về trang login
    header("Location: ../login.php");
    exit();
}

// Lấy user_id từ session
$userId = $_SESSION['user_id'];

// Chuẩn bị câu lệnh SQL để xóa thiết bị của user này
// Sử dụng prepared statement để chống SQL Injection
$stmt = $conn->prepare("DELETE FROM devices WHERE user_id = ?");

// Nếu prepare thất bại, ghi log và báo lỗi
if ($stmt === false) {
    error_log("Prepare failed: " . $conn->error);
    header("Location: ../dashboard.php?error=dberror");
    exit();
}

// Gán biến và thực thi
$stmt->bind_param("i", $userId);
$stmt->execute();

// Đóng statement và kết nối
$stmt->close();
$conn->close();

// Sau khi thực hiện xong, chuyển hướng người dùng trở lại dashboard
// Người dùng sẽ thấy trạng thái đã được cập nhật thành "Chưa kết nối"
header("Location: ../dashboard.php");
exit();
?>