<?php
session_start();
require '../includes/db_connect.php';

if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    exit("Bạn cần đăng nhập.");
}

// Lấy dữ liệu từ form POST
$repairId = $_POST['repairId'] ?? 0;
$customerName = $_POST['customerName'] ?? '';
$customerPhone = $_POST['customerPhone'] ?? '';
$vehicleType = $_POST['vehicleType'] ?? '';
$repairDescription = $_POST['repairDescription'] ?? '';
$pickupTime = $_POST['pickupTime'] ?? '';
$status = $_POST['status'] ?? '';

if (empty($repairId)) {
    header("Location: ../dashboard.php?error=missingid");
    exit();
}

// Câu lệnh UPDATE an toàn
$stmt = $conn->prepare(
    "UPDATE repairs SET customer_name = ?, customer_phone = ?, vehicle_type = ?, repair_description = ?, pickup_time = ?, status = ? WHERE id = ?"
);
$stmt->bind_param("ssssssi", $customerName, $customerPhone, $vehicleType, $repairDescription, $pickupTime, $status, $repairId);

if ($stmt->execute()) {
    header("Location: ../dashboard.php?success=updated");
} else {
    header("Location: ../edit_repair.php?id={$repairId}&error=dberror");
}

$stmt->close();
$conn->close();
exit();
?>