<?php
session_start();
require '../includes/db_connect.php';

if (!isset($_SESSION['user_id'])) { exit("Bạn cần đăng nhập."); }

$userIdToEdit = $_POST['user_id'] ?? 0;
$newPassword = $_POST['new_password'] ?? '';

if (empty($userIdToEdit)) { header("Location: ../settings.php?error=invalidid"); exit(); }

// Chỉ cập nhật mật khẩu nếu người dùng nhập mật khẩu mới
if (!empty($newPassword)) {
    $passwordHash = password_hash($newPassword, PASSWORD_DEFAULT);
    $stmt = $conn->prepare("UPDATE users SET password_hash = ? WHERE id = ?");
    $stmt->bind_param("si", $passwordHash, $userIdToEdit);
    $stmt->execute();
    $stmt->close();
}

header("Location: ../settings.php?success=userupdated");
$conn->close();
exit();
?>