<?php
header('Content-Type: application/json');
include '../includes/db_connect.php';

$data = json_decode(file_get_contents('php://input'), true);

$token = $data['token'] ?? '';
$userId = $data['userId'] ?? '';
$deviceUid = $data['deviceUid'] ?? '';

if (empty($token) || empty($userId) || empty($deviceUid)) {
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Thiếu dữ liệu ghép đôi.']);
    exit();
}

// Kiểm tra token từ database
$stmt = $conn->prepare("SELECT pairing_token FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user || $user['pairing_token'] === null || !hash_equals($user['pairing_token'], $token)) {
    http_response_code(401); // Unauthorized
    echo json_encode(['error' => 'Token không hợp lệ hoặc đã hết hạn.']);
    $conn->close();
    exit();
}

$apiKey = bin2hex(random_bytes(32));

// Xóa các thiết bị cũ của cùng user_id
$stmt_delete = $conn->prepare("DELETE FROM devices WHERE user_id = ?");
$stmt_delete->bind_param("i", $userId);
$stmt_delete->execute();
$stmt_delete->close();

// Thêm thiết bị mới vào
$stmt_insert = $conn->prepare("INSERT INTO devices (user_id, device_uid, api_key, status) VALUES (?, ?, ?, 'active')");
$stmt_insert->bind_param("iss", $userId, $deviceUid, $apiKey);

if ($stmt_insert->execute()) {
    $deviceId = $conn->insert_id;
    
    // Vô hiệu hóa token sau khi sử dụng thành công
    $stmt_update = $conn->prepare("UPDATE users SET pairing_token = NULL WHERE id = ?");
    $stmt_update->bind_param("i", $userId);
    $stmt_update->execute();
    $stmt_update->close();

    echo json_encode([
        'status' => 'success',
        'message' => 'Ghép đôi thành công!',
        'apiKey' => $apiKey,
        'deviceId' => $deviceId
    ]);
} else {
    http_response_code(500); // Internal Server Error
    echo json_encode(['error' => 'Không thể lưu thông tin thiết bị.']);
}

$stmt_insert->close();
$conn->close();
?>