<?php
session_start();
require '../includes/db_connect.php';

// Bảo vệ: Chỉ người dùng đã đăng nhập mới được thực hiện
if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    echo "Bạn cần đăng nhập.";
    exit();
}

// Lấy dữ liệu từ form
$phoneNumber = $_POST['phoneNumber'] ?? '';
$messageContent = $_POST['messageContent'] ?? '';
$scheduleTime = $_POST['scheduleTime'] ?? '';
$userId = $_SESSION['user_id'];

// Kiểm tra dữ liệu cơ bản
if (empty($phoneNumber) || empty($messageContent)) {
    header("Location: ../dashboard.php?error=missingdata");
    exit();
}

// Nếu người dùng không nhập thời gian, đặt là gửi ngay
if (empty($scheduleTime)) {
    // Lấy thời gian hiện tại theo múi giờ Việt Nam
    $scheduleTime = new DateTime("now", new DateTimeZone('Asia/Ho_Chi_Minh'));
    $scheduleTime = $scheduleTime->format('Y-m-d H:i:s');
}

// --- THAY ĐỔI QUAN TRỌNG: INSERT VÀO BẢNG "messages" VỚI TÊN CỘT ĐÚNG ---
$stmt = $conn->prepare("INSERT INTO messages (user_id, phone_number, message, schedule_time, status) VALUES (?, ?, ?, ?, 'pending')");
$stmt->bind_param("isss", $userId, $phoneNumber, $messageContent, $scheduleTime);

if ($stmt->execute()) {
    header("Location: ../dashboard.php?success=1");
} else {
    // Ghi lại lỗi để debug
    error_log("SQL Error: " . $stmt->error);
    header("Location: ../dashboard.php?error=dberror");
}

$stmt->close();
$conn->close();
exit();
?>