<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
include 'includes/header.php';
?>

<div class="card shadow-sm">
    <div class="card-header bg-white">
        <h5 class="card-title mb-0"><i class="fa-solid fa-wrench"></i> Thêm Lịch Sửa Chữa Mới</h5>
    </div>
    <div class="card-body">
        <form action="actions/add_repair_action.php" method="POST">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="customerName" class="form-label">Tên khách hàng</label>
                    <input type="text" class="form-control" id="customerName" name="customerName" placeholder="VD: Nguyễn Văn A" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="customerPhone" class="form-label">Số điện thoại</label>
                    <input type="tel" class="form-control" id="customerPhone" name="customerPhone" placeholder="VD: 09xxxxxxxx" required>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="vehicleType" class="form-label">Loại xe</label>
                    <select class="form-select" id="vehicleType" name="vehicleType" required>
                        <option value="xe đạp">Xe đạp</option>
                        <option value="xe đạp điện">Xe đạp điện</option>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="vehicleName" class="form-label">Tên xe / Model</label>
                    <input type="text" class="form-control" id="vehicleName" name="vehicleName" placeholder="VD: Martin 107, Asama..." required>
                </div>
            </div>
            <div class="mb-3">
                <label for="repairDescription" class="form-label">Nội dung sửa chữa</label>
                <textarea class="form-control" id="repairDescription" name="repairDescription" rows="4" placeholder="Mô tả tình trạng xe và các yêu cầu sửa chữa..." required></textarea>
            </div>
            <div class="mb-3">
                <label for="pickupTime" class="form-label">Thời gian hẹn lấy xe</label>
                <input type="datetime-local" class="form-control" id="pickupTime" name="pickupTime" required>
            </div>
            <div class="form-check mb-4">
                <input class="form-check-input" type="checkbox" name="sendSms" id="sendSms" value="1" checked>
                <label class="form-check-label" for="sendSms">
                    Tự động gửi SMS xác nhận & SMS hẹn lấy xe cho khách hàng
                </label>
            </div>
            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-primary btn-lg"><i class="fa-solid fa-save"></i> Lưu Lịch Sửa Chữa</button>
            </div>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>