<?php
header('Content-Type: application/json');
include '../includes/db_connect.php';

// Xác thực
$apiKey = $_SERVER['HTTP_X_API_KEY'] ?? '';
$deviceId = $_SERVER['HTTP_X_DEVICE_ID'] ?? '';
$data = json_decode(file_get_contents('php://input'), true);
$messageId = $data['message_id'] ?? null;
$status = $data['status'] ?? null;

if (empty($apiKey) || empty($deviceId) || !isset($messageId) || !in_array($status, ['sent', 'failed'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Thiếu hoặc sai tham số.']);
    exit();
}

$stmt = $conn->prepare("SELECT user_id FROM devices WHERE api_key = ? AND id = ? AND status = 'active'");
$stmt->bind_param("si", $apiKey, $deviceId);
$stmt->execute();
$result = $stmt->get_result();
$device = $result->fetch_assoc();

if (!$device) {
    http_response_code(401);
    echo json_encode(['error' => 'Thông tin xác thực không hợp lệ.']);
    exit();
}

// Cập nhật trạng thái
$stmt = $conn->prepare("UPDATE messages SET status = ?, sent_at = NOW() WHERE id = ? AND user_id = ?");
$stmt->bind_param("sii", $status, $messageId, $device['user_id']);

if ($stmt->execute() && $stmt->affected_rows > 0) {
    echo json_encode(['status' => 'success', 'message' => 'Cập nhật trạng thái thành công.']);
} else {
    http_response_code(404);
    echo json_encode(['error' => 'Không tìm thấy tin nhắn hoặc không có quyền cập nhật.']);
}

$stmt->close();
$conn->close();
?>