<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
include 'includes/db_connect.php';

// Lấy ID từ URL và lấy thông tin sửa chữa hiện tại
$repairId = $_GET['id'] ?? 0;
if (empty($repairId)) {
    header("Location: dashboard.php"); // Nếu không có ID, quay về trang chính
    exit();
}

$stmt = $conn->prepare("SELECT * FROM repairs WHERE id = ?");
$stmt->bind_param("i", $repairId);
$stmt->execute();
$result = $stmt->get_result();
$repair = $result->fetch_assoc();
$stmt->close();

if (!$repair) {
    exit("Không tìm thấy lịch sửa chữa này.");
}

include 'includes/header.php';
?>

<div class="card shadow-sm">
    <div class="card-header bg-white">
        <h5 class="card-title mb-0"><i class="fa-solid fa-edit"></i> Chỉnh Sửa Lịch Sửa Chữa</h5>
    </div>
    <div class="card-body">
        <form action="actions/edit_repair_action.php" method="POST">
            <input type="hidden" name="repairId" value="<?php echo $repair['id']; ?>">

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="customerName" class="form-label">Tên khách hàng</label>
                    <input type="text" class="form-control" id="customerName" name="customerName" value="<?php echo htmlspecialchars($repair['customer_name']); ?>" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="customerPhone" class="form-label">Số điện thoại</label>
                    <input type="tel" class="form-control" id="customerPhone" name="customerPhone" value="<?php echo htmlspecialchars($repair['customer_phone']); ?>" required>
                </div>
            </div>
            <div class="mb-3">
                <label for="vehicleType" class="form-label">Loại xe</label>
                <select class="form-select" id="vehicleType" name="vehicleType" required>
                    <option value="xe đạp" <?php if ($repair['vehicle_type'] == 'xe đạp') echo 'selected'; ?>>Xe đạp</option>
                    <option value="xe đạp điện" <?php if ($repair['vehicle_type'] == 'xe đạp điện') echo 'selected'; ?>>Xe đạp điện</option>
                </select>
            </div>
            <div class="mb-3">
                <label for="repairDescription" class="form-label">Nội dung sửa chữa</label>
                <textarea class="form-control" id="repairDescription" name="repairDescription" rows="4" required><?php echo htmlspecialchars($repair['repair_description']); ?></textarea>
            </div>
            <div class="mb-3">
                <label for="pickupTime" class="form-label">Thời gian hẹn lấy xe</label>
                <input type="datetime-local" class="form-control" id="pickupTime" name="pickupTime" value="<?php echo date('Y-m-d\TH:i', strtotime($repair['pickup_time'])); ?>" required>
            </div>
             <div class="mb-3">
                <label for="status" class="form-label">Trạng thái công việc</label>
                <select class="form-select" id="status" name="status" required>
                    <option value="đang sửa chữa" <?php if ($repair['status'] == 'đang sửa chữa') echo 'selected'; ?>>Đang sửa chữa</option>
                    <option value="đã sửa chữa" <?php if ($repair['status'] == 'đã sửa chữa') echo 'selected'; ?>>Đã sửa chữa</option>
                    <option value="đã trả hàng" <?php if ($repair['status'] == 'đã trả hàng') echo 'selected'; ?>>Đã trả hàng</option>
                </select>
            </div>
            <div class="d-flex justify-content-end">
                <a href="dashboard.php" class="btn btn-secondary me-2">Hủy</a>
                <button type="submit" class="btn btn-primary"><i class="fa-solid fa-save"></i> Cập Nhật</button>
            </div>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>