<?php
session_start();
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
include 'includes/db_connect.php';

$userIdToEdit = $_GET['id'] ?? 0;
if (empty($userIdToEdit)) { header("Location: settings.php"); exit(); }

$stmt = $conn->prepare("SELECT username FROM users WHERE id = ?");
$stmt->bind_param("i", $userIdToEdit);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
if (!$user) { exit("Không tìm thấy người dùng."); }
$stmt->close();

include 'includes/header.php';
?>
<div class="row justify-content-center">
    <div class="col-lg-6">
        <div class="card shadow-sm">
            <div class="card-header bg-white"><h5 class="card-title mb-0"><i class="fa-solid fa-user-edit"></i> Chỉnh Sửa Người Dùng</h5></div>
            <div class="card-body">
                <form action="actions/edit_user_action.php" method="POST">
                    <input type="hidden" name="user_id" value="<?php echo $userIdToEdit; ?>">
                    <div class="mb-3"><label class="form-label">Tên đăng nhập</label><input type="text" class="form-control" value="<?php echo htmlspecialchars($user['username']); ?>" disabled></div>
                    <div class="mb-3"><label for="new_password" class="form-label">Mật khẩu mới (để trống nếu không muốn đổi)</label><input type="password" class="form-control" id="new_password" name="new_password"></div>
                    <div class="d-flex justify-content-end">
                         <a href="settings.php" class="btn btn-secondary me-2">Hủy</a>
                        <button type="submit" class="btn btn-primary">Lưu Thay Đổi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php include 'includes/footer.php'; ?>