<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
include 'includes/db_connect.php';
include 'includes/header.php';

// Lấy dữ liệu lần đầu khi tải trang
$userId = $_SESSION['user_id'];
$messages = [];
$stmt = $conn->prepare("SELECT id, phone_number, message, schedule_time, status FROM messages WHERE user_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $messages = $result->fetch_all(MYSQLI_ASSOC);
}
$stmt->close();
// Không đóng $conn ở đây vì có thể cần dùng sau
?>

<div class="card shadow-sm">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0"><i class="fa-solid fa-history"></i> Lịch Sử Gửi Tin</h5>
        <button class="btn btn-sm btn-outline-secondary" onclick="location.reload();">
            <i class="fa-solid fa-sync"></i> Làm mới
        </button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Người nhận</th>
                        <th>Nội dung</th>
                        <th>Thời gian hẹn</th>
                        <th>Trạng thái</th>
                        <th>Hành động</th>
                    </tr>
                </thead>
                <tbody id="history-tbody">
                    <?php if (empty($messages)): ?>
                        <tr>
                            <td colspan="5" class="text-center text-muted">Chưa có tin nhắn nào trong lịch sử.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($messages as $message): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($message['phone_number']); ?></td>
                                <td class="text-truncate" style="max-width: 250px;" title="<?php echo htmlspecialchars($message['message']); ?>">
                                    <?php echo htmlspecialchars($message['message']); ?>
                                </td>
                                <td><?php echo date_format(date_create($message['schedule_time']), 'd-m-Y H:i'); ?></td>
                                <td>
                                    <?php
                                    $status = $message['status']; $badgeClass = ''; $statusText = '';
                                    switch ($status) {
                                        case 'sent': $badgeClass = 'bg-success'; $statusText = 'Đã gửi'; break;
                                        case 'failed': $badgeClass = 'bg-danger'; $statusText = 'Thất bại'; break;
                                        case 'sending': $badgeClass = 'bg-info'; $statusText = 'Đang gửi'; break;
                                        case 'pending': default: $badgeClass = 'bg-warning text-dark'; $statusText = 'Đang chờ'; break;
                                    }
                                    echo "<span class='badge {$badgeClass}'>{$statusText}</span>";
                                    ?>
                                </td>
                                <td>
                                    <a href="actions/delete_message.php?id=<?php echo $message['id']; ?>" class="btn btn-sm btn-outline-danger" title="Xóa tin nhắn" onclick="return confirm('Bạn có chắc chắn muốn xóa tin nhắn này?');">
                                        <i class="fa-solid fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
// Hàm để vẽ lại bảng dựa trên dữ liệu JSON
function renderHistoryTable(data) {
    const tbody = document.getElementById('history-tbody');
    tbody.innerHTML = ''; // Xóa toàn bộ nội dung cũ

    if (data.length === 0) {
        tbody.innerHTML = '<tr><td colspan="5" class="text-center text-muted">Chưa có tin nhắn nào trong lịch sử.</td></tr>';
        return;
    }

    data.forEach(msg => {
        // Định dạng lại ngày giờ
        const scheduleDate = new Date(msg.schedule_time);
        const formattedDate = ('0' + scheduleDate.getDate()).slice(-2) + '-' + ('0' + (scheduleDate.getMonth() + 1)).slice(-2) + '-' + scheduleDate.getFullYear() + ' ' + ('0' + scheduleDate.getHours()).slice(-2) + ':' + ('0' + scheduleDate.getMinutes()).slice(-2);

        // Tạo HTML cho trạng thái
        let statusBadge = '';
        switch (msg.status) {
            case 'sent': statusBadge = '<span class="badge bg-success">Đã gửi</span>'; break;
            case 'failed': statusBadge = '<span class="badge bg-danger">Thất bại</span>'; break;
            case 'sending': statusBadge = '<span class="badge bg-info">Đang gửi</span>'; break;
            default: statusBadge = '<span class="badge bg-warning text-dark">Đang chờ</span>'; break;
        }

        const row = `
            <tr>
                <td>${msg.phone_number}</td>
                <td class="text-truncate" style="max-width: 250px;" title="${msg.message}">${msg.message}</td>
                <td>${formattedDate}</td>
                <td>${statusBadge}</td>
                <td>
                    <a href="actions/delete_message.php?id=${msg.id}" class="btn btn-sm btn-outline-danger" title="Xóa tin nhắn" onclick="return confirm('Bạn có chắc chắn muốn xóa tin nhắn này?');">
                        <i class="fa-solid fa-trash"></i>
                    </a>
                </td>
            </tr>
        `;
        tbody.innerHTML += row;
    });
}

// Hàm gọi API để lấy dữ liệu mới
async function fetchLatestHistory() {
    try {
        const response = await fetch('api/get_history_updates.php');
        if (!response.ok) {
            // Nếu có lỗi (vd: session hết hạn), dừng việc tự cập nhật
            clearInterval(pollingInterval);
            return;
        }
        const data = await response.json();
        renderHistoryTable(data);
    } catch (error) {
        console.error('Lỗi khi cập nhật lịch sử:', error);
        clearInterval(pollingInterval); // Dừng lại nếu có lỗi mạng
    }
}

// Cứ mỗi 5 giây, gọi hàm fetchLatestHistory một lần
const pollingInterval = setInterval(fetchLatestHistory, 5000);
</script>

<?php include 'includes/footer.php'; ?>