<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hệ Thống Quản Lý Sửa Chữa & SMS</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"/>
    
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="bg-light">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm">
        <div class="container">
            <a class="navbar-brand fw-bold" href="dashboard.php">
                <i class="fa-solid fa-comment-dots"></i> SMS Scheduler
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php"><i class="fa-solid fa-list-check"></i> Lịch Sửa Chữa</a>
                    </li>
                     <li class="nav-item">
                        <a class="nav-link" href="add_repair.php"><i class="fa-solid fa-wrench"></i> Thêm Sửa Chữa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#" data-bs-toggle="modal" data-bs-target="#quickSmsModal">
                            <i class="fa-solid fa-paper-plane"></i> Gửi Tin Nhanh
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="history.php"><i class="fa-solid fa-history"></i> Lịch Sử SMS</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="pair-device.php"><i class="fa-solid fa-qrcode"></i> Kết Nối Thiết Bị</a>
                    </li>
                   
                    <li class="nav-item">
                        <a class="nav-link" href="settings.php"><i class="fa-solid fa-cog"></i> Cài Đặt</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php"><i class="fa-solid fa-sign-out-alt"></i> Đăng Xuất</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <main class="container my-4">

<div class="modal fade" id="quickSmsModal" tabindex="-1" aria-labelledby="quickSmsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="quickSmsModalLabel"><i class="fa-solid fa-paper-plane"></i> Soạn Tin Nhắn Nhanh</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="actions/schedule_action.php" method="POST" id="quickSmsForm">
                    <div class="mb-3">
                        <label for="phoneNumberModal" class="form-label">Số điện thoại người nhận</label>
                        <input type="tel" class="form-control" id="phoneNumberModal" name="phoneNumber" placeholder="VD: 09xxxxxxxx" required>
                    </div>
                    <div class="mb-3">
                        <label for="messageContentModal" class="form-label">Nội dung tin nhắn</label>
                        <textarea class="form-control" id="messageContentModal" name="messageContent" rows="4" placeholder="Nhập nội dung..." required></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="scheduleTimeModal" class="form-label">Thời gian gửi (để trống nếu gửi ngay)</label>
                        <input type="datetime-local" class="form-control" id="scheduleTimeModal" name="scheduleTime">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                <button type="submit" form="quickSmsForm" class="btn btn-primary">Gửi Tin Nhắn</button>
            </div>
        </div>
    </div>
</div>