<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

include 'includes/db_connect.php';
include 'includes/header.php';

// --- LOGIC KIỂM TRA TRẠNG THÁI THIẾT BỊ ---
$isDeviceConnected = false;
$stmt = $conn->prepare("SELECT id FROM devices WHERE user_id = ? AND status = 'active'");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows > 0) {
    $isDeviceConnected = true;
}
$stmt->close();

// --- LẤY LỊCH SỬ TIN NHẮN TỪ DATABASE ---
$messages = [];
$stmt = $conn->prepare("SELECT phone_number, message, schedule_time, status FROM messages WHERE user_id = ? ORDER BY created_at DESC LIMIT 20");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $messages[] = $row;
}
$stmt->close();
?>

<div class="row">
    <div class="col-lg-5 mb-4">
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-white">
                <h5 class="card-title mb-0"><i class="fa-solid fa-mobile-alt"></i> Trạng Thái Thiết Bị</h5>
            </div>
            <div class="card-body text-center d-flex flex-column justify-content-center">
                <?php if ($isDeviceConnected): ?>
                    <i class="fa-solid fa-circle-check text-success fa-3x mb-3"></i>
                    <h6 class="mb-1">Thiết bị Android</h6>
                    <p class="text-muted">Đã kết nối và sẵn sàng gửi tin.</p>
                    <a href="actions/disconnect_action.php" class="btn btn-outline-danger btn-sm mt-auto">Hủy kết nối</a>
                <?php else: ?>
                    <i class="fa-solid fa-circle-xmark text-danger fa-3x mb-3"></i>
                    <h6 class="mb-1">Chưa có thiết bị nào được kết nối</h6>
                    <p class="text-muted">Bạn cần kết nối với điện thoại để có thể gửi tin nhắn.</p>
                    <a href="pair-device.php" class="btn btn-primary mt-auto">Kết nối ngay</a>
                <?php endif; ?>
            </div>
        </div>
        <div class="card shadow-sm">
            <div class="card-header bg-white">
                <h5 class="card-title mb-0"><i class="fa-solid fa-pencil-alt"></i> Soạn Tin Nhắn Mới</h5>
            </div>
            <div class="card-body">
                <form action="actions/schedule_action.php" method="POST">
                    <div class="mb-3">
                        <label for="phoneNumber" class="form-label">Số điện thoại người nhận</label>
                        <input type="tel" class="form-control" id="phoneNumber" name="phoneNumber" placeholder="VD: 09xxxxxxxx" required>
                    </div>
                    <div class="mb-3">
                        <label for="messageContent" class="form-label">Nội dung tin nhắn</label>
                        <textarea class="form-control" id="messageContent" name="messageContent" rows="5" placeholder="Nhập nội dung..." required></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="scheduleTime" class="form-label">Thời gian gửi (để trống nếu gửi ngay)</label>
                        <input type="datetime-local" class="form-control" id="scheduleTime" name="scheduleTime">
                    </div>
                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary" <?php echo !$isDeviceConnected ? 'disabled' : ''; ?>>
                            <i class="fa-solid fa-calendar-check"></i> Lưu Lịch Gửi
                        </button>
                    </div>
                     <?php if (!$isDeviceConnected): ?>
                        <small class="form-text text-danger d-block text-end mt-2">Bạn phải kết nối thiết bị trước khi gửi.</small>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-7 mb-4">
        <div class="card shadow-sm h-100">
            <div class="card-header bg-white">
                <h5 class="card-title mb-0"><i class="fa-solid fa-history"></i> Lịch Sử Gửi Tin</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Người nhận</th>
                                <th>Nội dung</th>
                                <th>Thời gian hẹn</th>
                                <th>Trạng thái</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($messages)): ?>
                                <tr>
                                    <td colspan="4" class="text-center text-muted">Chưa có tin nhắn nào.</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($messages as $msg): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($msg['phone_number']); ?></td>
                                        <td class="text-truncate" style="max-width: 200px;" title="<?php echo htmlspecialchars($msg['message']); ?>"><?php echo htmlspecialchars($msg['message']); ?></td>
                                        <td><?php echo htmlspecialchars(date('d-m-Y H:i', strtotime($msg['schedule_time']))); ?></td>
                                        <td>
                                            <?php
                                            $status_class = ''; $status_text = '';
                                            switch ($msg['status']) {
                                                case 'sent': $status_class = 'bg-success'; $status_text = 'Đã gửi'; break;
                                                case 'pending': $status_class = 'bg-warning text-dark'; $status_text = 'Đang chờ'; break;
                                                case 'failed': $status_class = 'bg-danger'; $status_text = 'Thất bại'; break;
                                                case 'sending': $status_class = 'bg-info text-dark'; $status_text = 'Đang gửi'; break;
                                            }
                                            echo "<span class='badge {$status_class}'>{$status_text}</span>";
                                            ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
?>