<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require 'vendor/autoload.php';
require 'config.php';
include 'includes/db_connect.php';

use Endroid\QrCode\Builder\Builder;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\Writer\PngWriter;

// Tạo token ghép đôi
$pairingToken = bin2hex(random_bytes(32));
$userId = $_SESSION['user_id'];

// Lưu token vào database
$stmt = $conn->prepare("UPDATE users SET pairing_token = ? WHERE id = ?");
$stmt->bind_param("si", $pairingToken, $userId);
$stmt->execute();
$stmt->close();

$apiUrl = BASE_URL . '/actions/pair_action.php';

$qrData = json_encode([
    'userId' => $userId,
    'token' => $pairingToken,
    'apiUrl' => $apiUrl
]);

$result = Builder::create()->writer(new PngWriter())->data($qrData)->encoding(new Encoding('UTF-8'))->size(300)->margin(10)->build();
$qrCodeDataUri = $result->getDataUri();

include 'includes/header.php';
?>

<div class="row justify-content-center">
    <div class="col-lg-6">
        <div class="card shadow-sm text-center">
            <div class="card-header bg-white">
                <h5 class="card-title mb-0"><i class="fa-solid fa-qrcode"></i> Kết Nối Với Thiết Bị Android</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">Mở ứng dụng SMS Scheduler trên điện thoại và quét mã này.</p>
                <div class="qr-code-container my-4">
                    <img src="<?php echo $qrCodeDataUri; ?>" alt="QR Code">
                </div>
                <div id="status-checking">
                    <div class="spinner-border spinner-border-sm" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <span class="text-muted">Đang chờ thiết bị quét mã...</span>
                </div>
                <div id="status-success" class="alert alert-success d-none mt-3">
                    <i class="fa-solid fa-circle-check"></i> Kết nối thành công! Đang chuyển hướng...
                </div>
            </div>
        </div>
    </div>
</div>

<script>
async function checkPairingStatus() {
    try {
        const response = await fetch('api/check_pairing_status.php');
        const data = await response.json();
        if (data.status === 'paired') {
            document.getElementById('status-checking').classList.add('d-none');
            document.getElementById('status-success').classList.remove('d-none');
            clearInterval(pairingInterval);
            setTimeout(() => { window.location.href = 'index.php'; }, 2000);
        }
    } catch (error) {
        console.error('Lỗi khi kiểm tra trạng thái:', error);
    }
}
const pairingInterval = setInterval(checkPairingStatus, 3000);
</script>

<?php include 'includes/footer.php'; ?>