<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
include 'includes/db_connect.php';
include 'includes/header.php';

// Lấy danh sách sửa chữa từ DB
$repairs = [];
$stmt = $conn->prepare("SELECT id, customer_name, customer_phone, vehicle_type, pickup_time, status FROM repairs ORDER BY created_at DESC");
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $repairs = $result->fetch_all(MYSQLI_ASSOC);
}
$stmt->close();
?>

<div class="card shadow-sm">
    <div class="card-header bg-white">
        <h5 class="card-title mb-0"><i class="fa-solid fa-list-check"></i> Lịch Sử Sửa Chữa</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Khách hàng</th>
                        <th>SĐT</th>
                        <th>Loại xe</th>
                        <th>Hẹn lấy</th>
                        <th>Trạng thái</th>
                        <th>Hành động</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($repairs)): ?>
                        <tr><td colspan="6" class="text-center text-muted">Chưa có lịch sử sửa chữa.</td></tr>
                    <?php else: ?>
                        <?php foreach ($repairs as $repair): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($repair['customer_name']); ?></td>
                                <td><?php echo htmlspecialchars($repair['customer_phone']); ?></td>
                                <td><?php echo htmlspecialchars($repair['vehicle_type']); ?></td>
                                <td><?php echo date_format(date_create($repair['pickup_time']), 'H:i d/m/Y'); ?></td>
                                <td>
                                    <?php
                                    // Hiển thị trạng thái theo màu
                                    $status = $repair['status'];
                                    $badge = '';
                                    if ($status == 'đang sửa chữa') $badge = '<span class="badge bg-warning text-dark">Đang sửa</span>';
                                    if ($status == 'đã sửa chữa') $badge = '<span class="badge bg-info">Đã sửa xong</span>';
                                    if ($status == 'đã trả hàng') $badge = '<span class="badge bg-success">Đã trả hàng</span>';
                                    echo $badge;
                                    ?>
                                </td>
                                <td>
                                    <?php if ($status == 'đang sửa chữa'): ?>
                                        <a href="#" class="btn btn-sm btn-outline-primary">Hoàn thành</a>
                                    <?php elseif ($status == 'đã sửa chữa'): ?>
                                        <a href="#" class="btn btn-sm btn-success">Trả hàng</a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>