<?php
session_start();
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
include 'includes/db_connect.php';
include 'includes/header.php';

// Lấy danh sách tất cả người dùng
$users = $conn->query("SELECT id, username, created_at FROM users ORDER BY created_at DESC")->fetch_all(MYSQLI_ASSOC);
?>

<div class="card shadow-sm">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0"><i class="fa-solid fa-users"></i> Quản Lý Người Dùng</h5>
        <a href="add_user.php" class="btn btn-primary"><i class="fa-solid fa-user-plus"></i> Thêm Người Dùng</a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Tên đăng nhập</th>
                        <th>Ngày tạo</th>
                        <th class="text-center">Hành động</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?php echo $user['id']; ?></td>
                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                            <td><?php echo date_format(date_create($user['created_at']), 'd/m/Y H:i'); ?></td>
                            <td class="text-center">
                                <div class="btn-group">
                                    <a href="edit_user.php?id=<?php echo $user['id']; ?>" class="btn btn-sm btn-outline-secondary" title="Sửa">
                                        <i class="fa-solid fa-edit"></i> Sửa
                                    </a>
                                    <?php if ($user['id'] != $_SESSION['user_id']): // Ngăn không cho tự xóa chính mình ?>
                                        <a href="actions/delete_user_action.php?id=<?php echo $user['id']; ?>" class="btn btn-sm btn-outline-danger" title="Xóa" onclick="return confirm('Bạn có chắc chắn muốn xóa người dùng này?');">
                                            <i class="fa-solid fa-trash"></i> Xóa
                                        </a>
                                    <?php else: ?>
                                         <button class="btn btn-sm btn-outline-danger" disabled title="Không thể tự xóa tài khoản của bạn">
                                            <i class="fa-solid fa-trash"></i> Xóa
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>